<?php

namespace App\Exports;

use App\Models\Document;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use PhpOffice\PhpSpreadsheet\Shared\Date;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class DocumentsExport implements FromCollection,WithHeadings,WithColumnFormatting
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        return Document::select('id','notification_number','amount'
        
        )->get();
    }
    // public function map($document): array
    // {
    //     return [
    //         $document->id,
    //         Date::dateTimeToExcel($document->created_at),
    //         $document->amount
    //     ];
    // }
    
    public function columnFormats(): array
    {
        return [
            //'B' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'C' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
        ];
    }


    public function headings(): array
    {
        return [
            'Student_id','Notification Number','Amount',
        ];
    }



}
