<?php

namespace App\Helpers;
use Request;
use App\Models\Log_activities as LogActivityModel;
use Carbon\Carbon;
class LogActivity
{

    public static function addToLog($subject)
    {
        $log = [];
        $log['subject'] = $subject;
        $log['url'] = Request::fullUrl();
        $log['method'] = Request::method();
        $log['ip'] = Request::ip();
        $log['Date'] = Carbon::now();
        $log['agent'] = Request::header('user-agent');
        $log['user_id'] = auth()->check() ? auth()->user()->id : 0;
        LogActivityModel::create($log);
    }

    public static function logActivityLists()
    {
        return LogActivityModel::join('users','users.id','=','log_activities.user_id')->orderBy('Date', 'asc')->get();
    }

}