<?php

namespace App\Http\Controllers;

use App\Models\Delivery;
use App\Models\Certificat;
use App\Models\User;
use App\Models\Record;
use App\Models\Register;
use App\Models\Statment;
use App\Http\Requests\StoreDeliveryRequest;
use App\Http\Requests\UpdateDeliveryRequest;
use Illuminate\Support\Facades\Auth; 
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Image;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Notification;
use App\Notifications\DeliveryCreate;
use App\Notifications\DocumentConfirm;

class DeliveryController extends Controller
{
    function __construct()
    { 

    $this->middleware('permission:عرض التسليم', ['only' => ['index']]);
    $this->middleware('permission:اضافة التسليم', ['only' => ['create','store']]);
    $this->middleware('permission:تعديل التسليم', ['only' => ['edit','update']]);
    $this->middleware('permission:حذف التسليم', ['only' => ['destroy']]);

    }
    public function index()
    {
    

        if(Auth::user()->user_type == 'stu')
        {
            $deliveries = Delivery::where('user_id', Auth::user()->id)->get();

        }
        else
        {
           
             $deliveries = Delivery::where('stutus',0)->get();

        }
        return view('pages.Deliverys.index',compact('deliveries'));
    }

   
    public function create()
    {
        $certificats = Certificat::where('user_id', Auth::user()->id)
        ->where('f_status','1')
        ->where('r_status','1')
        ->get();
        $record = Record::where('user_id', Auth::user()->id)
        ->where('f_status','1')
        ->where('r_status','1')
        ->get();
        $register = Register::where('user_id', Auth::user()->id)
        ->where('f_status','1')
        ->where('r_status','1')
        ->get();
        $statment = Statment::where('user_id', Auth::user()->id)
        ->where('f_status','1')
        ->where('r_status','1')
        ->get();
        
        return view('pages.Deliverys.create',compact('certificats','record','register','statment'));
    }

   
    public function store(StoreDeliveryRequest $request)
    {
        if(Delivery::where('user_id',Auth::user()->id)->exists())
        {
           return redirect()->back()->withErrors('تم أضافة مستلم مسبقاً');
        }

       
        try 
        {
            $validated = $request->validated();

            $delivery = new Delivery; 

            $delivery->midell_name =  $request->midell_name;
            $delivery->second_name = $request->second_name;
            $delivery->first_name = $request->first_name;
            $delivery->last_name = $request->last_name;
            $delivery->user_id = Auth::user()->id;
            $delivery->type = $request->docType;
            
            if($request->docType == 1)
            {
                $certificat = Certificat::where('user_id',Auth::user()->id)->first();
                if($certificat == null)
                {
                    return redirect()->back()->withErrors('لم يتم التقديم لشهادة تخرج');
                }
                else
                {
                    $certificat_no= $certificat->id;
                    $delivery->certificat_id = $certificat_no; 
                }
                
            }
            elseif($request->docType == 2)
            {
                $statment = Statment::where('user_id',Auth::user()->id)->first();
                
                if($statment == null)
                {
                    return redirect()->back()->withErrors('لم يتم التقديم لأفادة تخرج');
                }
                else
                {
                    $statment_no= $statment->id;
                    $delivery->statment_id = $statment_no; 
                }
               
            }
            elseif($request->docType == 3)
            {
                $record = Record::where('user_id',Auth::user()->id)->first();
                if($record == null)
                {
                    return redirect()->back()->withErrors('لم يتم التقديم لشهادة قيد');
                }
                else
                {
                    $record_no= $record->id;
                    $delivery->record_id = $record_no;
                }
                 
            }
            elseif($request->docType == 4)
            {
                $register = Register::where('user_id',Auth::user()->id)->first();
                if($register == null)
                {
                    return redirect()->back()->withErrors('لم يتم التقديم لسجل اكاديمي');
                }
                else{
                    $register_no= $register->id;
                    $delivery->register_id = $register_no; 
                }
                
            }
            
            if ($request->hasFile('ssn')) {
                $image = $request->file('ssn');
                $filename = time() . '.' . $image->getClientOriginalExtension();
                $location = '/home/eustedu/certificats.eust.edu.sd/images/ssn/' . $filename;
                Image::make($image)->resize(500, 600)->save($location);
                $delivery->ssn = $filename;
            }  
            $delivery->save();

            $user = User::where('id',Auth::user()->id)->first();
            Notification::send($user, new \App\Notifications\DeliveryCreate);

              toastr()->success(trans('messages.success'));
              return redirect()->route('deliveries.index');

        }

        catch (\Exception $e){
            return redirect()->back()->withErrors(['error' => $e->getMessage()]);
        }

    }

   
    public function show($id)
    {
        $delivery = Delivery::find(decrypt($id));
        return view('pages.Deliverys.show',compact('delivery'));
    }

   
    public function edit($id)
    {
        $delivery = Delivery::find(decrypt($id));
      
        return view('pages.Deliverys.edit',compact('delivery'));
    }

    
    public function update(UpdateDeliveryRequest $request, Delivery $delivery)
    {
        try {
           
            $delivery->first_name = $request->first_name;
            $delivery->second_name = $request->second_name;
            $delivery->midell_name = $request->midell_name;
            $delivery->last_name = $request->last_name;
            if ($request->hasFile('ssn')) {
                Storage::delete($delivery->ssn);
                $image = $request->file('ssn');
                $filename = time() . '.' . $image->getClientOriginalExtension();
                $location = '/home/eustedu/certificats.eust.edu.sd/images/ssn/' . $filename;
                Image::make($image)->resize(500, 600)->save($location);
                $delivery->ssn = $filename;
            }  

            $delivery->save();
                
            toastr()->success(trans('messages.Update')); 
            return redirect()->route('deliveries.index');
            }
            catch (\Exception $e){
                return redirect()->back()->withErrors(['error' => $e->getMessage()]);
            }

    }

    
    public function destroy(Request $request)
    {
        try {
            $delivery = Delivery::where('id',$request->id)->first();
            
             $delivery->delete();
             toastr()->error(trans('messages.Delete'));
            return redirect()->route('deliveries.index');
        }

        catch (\Exception $e){
        return redirect()->back()->withErrors(['error' => $e->getMessage()]);
        }
    }

    // 
    public function deliveryprocess(Request $request)
    {
       
            $validatedData = $request->validate([
                'rdio' => 'required',
            ],[

                'rdio.required' =>'يرجي تحديد حالة طلب الاستلام',
            
            ]);
           try {
                $delivery = Delivery::where('id',$request->id)->first();
                $delivery->update([
                'stutus' => $request->rdio,
                'emp'=> Auth::user()->first_name,
                'note' => $request->note,
                    ]);
                }
                
                catch (\Exception $e){
                return redirect()->back()->withErrors(['error' => $e->getMessage()]);
                }

                
                $user = User::where('id',$delivery->user_id)->first();
                 Notification::send($user, new \App\Notifications\DocumentConfirm);

                toastr()->success(trans('messages.success'));
                return redirect('/deliveries');

    }
    
     public function ArchivDelivery() 
    {
        $deliveries = Delivery::onlyTrashed()->get();
        return view('pages.Deliverys.ArchivDelivery',compact('deliveries'));
      
    }

    public function RestoerDelivery(Request $request) 
    {
       $id=$request->id;
        $deliveries = Delivery::withTrashed()->where('id', $id)->restore();
      
        toastr()->success(trans('messages.success'));
        return redirect()->back();
    }
     public function DeliveryComplate()
    {
        $deliveries = Delivery::where('stutus','1')->get();
        return view('pages.reports.DeliveryComplate',compact('deliveries'));
    }


}//end of controller
