<?php

namespace App\Http\Controllers;

use App\Models\Document;
use App\Models\Certificat;
use App\Models\User;
use App\Http\Requests\StoreDocumentRequest;
use App\Http\Requests\UpdateDocumentRequest;
use Illuminate\Support\Facades\Auth; 
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Image;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Notification;
use App\Notifications\DocumentStautusChange;
use App\Notifications\DocumentCreate;
use App\Notifications\DocumentPuy;
use App\Exports\DocumentsExport;
use Maatwebsite\Excel\Facades\Excel;

class DocumentController extends Controller
{
   
    function __construct()
    { 
    //CertificatProcessResult  CertificatProcessPay
    $this->middleware('permission:عرض التوثيق', ['only' => ['index']]);
    $this->middleware('permission:اضافة التوثيق', ['only' => ['create','store']]);
    $this->middleware('permission:تعديل التوثيق', ['only' => ['edit','update']]);
    $this->middleware('permission:حذف التوثيق', ['only' => ['destroy']]);
    $this->middleware('permission:المالية', ['only' => ['DocumentPay']]);
    $this->middleware('permission:اجراء التوثيق', ['only' => ['DocumentProcess']]);
    }

    public function index()
    {
         try {
                if(Auth::user()->user_type == 'stu')
                {
                    $documents = Document::where('user_id', Auth::user()->id)->get();
                   // $certificat = Certificat::where('user_id',Auth::user()->id)->first();
                }
                else
                {
                    $documents = Document::all();
                }
         }
        catch (\Exception $e){
            return redirect()->back()->withErrors(['error' => $e->getMessage()]);
             }
                 
       //dd($documents);
        return view('pages.Documents.index',compact('documents'));
    }

   
    public function create()
    {
        if(Document::where('user_id',Auth::user()->id)->exists())
        {
           return redirect()->back()->withErrors('تم التقديم مسبقاً');
        }
        
        $certificatcomplate =  Certificat::where('user_id', Auth::user()->id)
        ->where('f_status','1')
        ->where('r_status','1')
        ->where('print','1')
        ->first();    
        // dd($certificatcomplate);
        return view('pages.Documents.create',compact('certificatcomplate'));
    }

   
    public function store(StoreDocumentRequest $request)
    {
        if($request->type == ["1","4"])
        {
           return redirect()->back()->withErrors('نوع التوثيق الذي تم اختيارة غير متاح');
        }
        elseif($request->type == ["2","3"])
        {
           return redirect()->back()->withErrors('نوع التوثيق الذي تم اختيارة غير متاح');
        }

        if(Document::where('user_id',Auth::user()->id)->exists())
        {
           return redirect()->back()->withErrors('تم التقديم مسبقاً');
        }

        //dd($request->all());
        $certificat = Certificat::where('user_id',Auth::user()->id)->first();
        $certificat_id = $certificat->id;
        $user = User::where('id',Auth::user()->id)->first();
        $user_id = $user->id;

        try {
           
            $validated = $request->validated();
           
            $document = new Document; 
            $document->certificat_id = $certificat_id;
            $document->user_id = $user_id;
            $document->amount = $request->amount;
            $document->type = $request->type;
            $document->notification_number = $request->notification_number;
            // $document->midell_name = $request->midell_name; 
            // $document->last_name = $request->last_name;
           
            if ($request->hasFile('bank')) {
                $image = $request->file('bank');
                $filename = time() . '.' . $image->getClientOriginalExtension();
                $location ='/home/eustedu/certificats.eust.edu.sd/images/bank/' . $filename;
                Image::make($image)->resize(500, 600)->save($location);
                $document->bank = $filename;
            } 
           
            $document->save();

            Notification::send($user, new \App\Notifications\DocumentCreate);

            toastr()->success(trans('messages.success'));
            return redirect()->route('documents.index');
         }
    
            catch (\Exception $e){
            return redirect()->back()->withErrors(['error' => $e->getMessage()]);
             }
      
    }

    
    public function show($id)
    {
        $document = Document::find(decrypt($id));
       return view('pages.Documents.show',compact('document'));
    }

    
    public function edit(Document $document)
    {
        //
    }

   
    public function update(UpdateDocumentRequest $request, Document $document)
    {
        //
    }

   
    public function destroy(Request $request)
    {
        try {
            $document = Document::where('id',$request->id)->first();
           
             $document->delete();
             toastr()->error(trans('messages.Delete'));
            return redirect()->route('documents.index');
        }

        catch (\Exception $e){
        return redirect()->back()->withErrors(['error' => $e->getMessage()]);
        }
    }

    public function DocumentProcess(Request $request)
    {
       
            $validatedData = $request->validate([
                'rdio' => 'required',
            ],[

                'rdio.required' =>'يرجي تحديد حالة طلب التوثيق',
            
            ]);
           try {
                $document = Document::where('id',$request->id)->first();
                $user_id=$document->user_id;
                $document->update([
                'stutus' => $request->rdio,
                'note' => $request->note,
                    ]);
                }
                
                catch (\Exception $e){
                return redirect()->back()->withErrors(['error' => $e->getMessage()]);
                }

                
                //  $user = User::where('id',$user_id)->first();
                //  Notification::send($user, new \App\Notifications\DocumentStautusChange);

                toastr()->success(trans('messages.success'));
                return redirect('/documents');

    }

    public function DocumentPay(Request $request)
    {
       
            $validatedData = $request->validate([
                'rdio' => 'required',
            ],[

                'rdio.required' =>'يرجي تحديد الحالة المالية لطلب التوثيق',
            
            ]);
           try {
                $document = Document::where('id',$request->id)->first();
                $user_id=$document->user_id;
                $document->update([
                'f_status' => $request->rdio,
                'f_note' => $request->note,
                    ]);
                }
                
                catch (\Exception $e){
                return redirect()->back()->withErrors(['error' => $e->getMessage()]);
                }

            //   $user = User::where('id',$user_id)->first();
            //     Notification::send($user, new \App\Notifications\DocumentPuy);

                toastr()->success(trans('messages.success'));
                return redirect('/documents');

    }
    
     public function ArchivDocument() 
    {
        $documents = Document::onlyTrashed()->get();
        return view('pages.Documents.ArchiveDocument',compact('documents'));
       
    }

    public function RestoerDocument(Request $request) 
    {
       $id=$request->id;
        $Document = Document::withTrashed()->where('id', $id)->restore();
      
        toastr()->success(trans('messages.success'));
        return redirect()->back();
    }
    
    public function DocumentsExport() 
    {
        return Excel::download(new DocumentsExport, 'DocumentsExports.xlsx');
    }
    
    
}
