<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\Certificat;
use App\Models\Register;
use App\Models\Record;
use App\Models\Statment;
use Illuminate\Support\Facades\Auth;
use App\Models\Delivery;
use App\Models\Document;
use App\Models\Refund;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //$this->middleware('auth');
        $this->middleware(['auth','verified']);
    }
    public function myCaptcha()

    {

        return view('myCaptcha');

    }
    public function myCaptchaPost(Request $request)

    {

        request()->validate([
            'email' => 'required|email',
            'password' => 'required',
            'captcha' => 'required|captcha'
        ],

        ['captcha.captcha'=>'Invalid captcha code.']);

        dd("You are here :) .");

    }
    public function refreshCaptcha()

    {
        return response()->json(['captcha'=> captcha_img()]);
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $certificats = Certificat::where('user_id', Auth::user()->id)->get();
        $registers = Register::where('user_id', Auth::user()->id)->get();
        $records = Record::where('user_id', Auth::user()->id)->get();
        $statments = Statment::where('user_id', Auth::user()->id)->get();
        $deliveries = Delivery::where('user_id', Auth::user()->id)->get();
        $documents = Document::where('user_id', Auth::user()->id)->get();
        $refunds = Refund::where('user_id', Auth::user()->id)->get();
        return view('dashboard',compact('refunds','documents','certificats','registers','records','statments','deliveries'));
    }

    
}
