<?php

namespace App\Http\Controllers;

use App\Models\Refund;
use App\Http\Requests\StoreRefundRequest;
use App\Http\Requests\UpdateRefundRequest;
use Illuminate\Support\Facades\Auth; 
use Image;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;
use App\Models\Certificat;
use App\Models\Statment;
use App\Models\Register;
use App\Models\Record;
use App\Models\Document;

use App\Exports\RefundsExport;

class RefundController extends Controller
{
   
    public function index()
    {
        try {
                if(Auth::user()->user_type == 'stu')
                {
                    $refunds = Refund::where('user_id', Auth::user()->id)->get();
                }
                else
                {
                    $refunds = Refund::all();
                }
            }
        catch (\Exception $e){
            return redirect()->back()->withErrors(['error' => $e->getMessage()]);
                }

         return view('pages.Refunds.index',compact('refunds'));
    }

    public function create()
    {
        try {
            $record =  Record::where('user_id',Auth::user()->id)->where('f_status','2')->first();
            $certificat =  Certificat::where('user_id',Auth::user()->id)->where('f_status','2')->first();
            $register =  Register::where('user_id',Auth::user()->id)->where('f_status','2')->first();
            $statment =  Statment::where('user_id',Auth::user()->id)->where('f_status','2')->first();
            $document =  Document::where('user_id',Auth::user()->id)->where('f_status','2')->first();
             
            return view('pages.Refunds.create',compact('record','certificat','register','statment','document'));
            }
    
            catch (\Exception $e){
            return redirect()->back()->withErrors(['error' => $e->getMessage()]);
            }
    }

    public function store(StoreRefundRequest $request)
    {
       
        try {
           
               //$validated = $request->validated();
               if(Refund::where('user_id',Auth::user()->id)->exists())
               {
                  return redirect()->back()->withErrors('تم التقديم مسبقاً لأسترداد الرسوم');
               }

                if ($request->has('record_id')) {
                    $record =  Record::where('id',$request->record_id)->first();
                    $refund = new Refund; 
                    $refund->user_id = Auth::user()->id;
                    $refund->amount = $record->amount;
                    $refund->notification = $record->image;
                    $refund->notification_number = $record->notification_number;
                    $refund->type = '3';
                    $refund->bank_account = $request->bank_account;
                    $refund->account_owner = $request->account_owner;
                    $refund->save();
                } 
                elseif ($request->has('register_id')) {
                    $register =  Register::where('id',$request->register_id)->first();
                    $refund = new Refund; 
                    $refund->user_id = Auth::user()->id;
                    $refund->amount = $register->amount;
                    $refund->notification = $register->bank;
                    $refund->notification_number = $register->notification_number;
                    $refund->type = '4';
                    $refund->bank_account = $request->bank_account;
                    $refund->account_owner = $request->account_owner;
                    $refund->save();
                }
                
                elseif ($request->has('statment_id')) {
                    $statment =  Statment::where('id',$request->statment_id)->first();
                    $refund = new Refund; 
                    $refund->user_id = Auth::user()->id;
                    $refund->amount = $statment->amount;
                    $refund->notification = $statment->image;
                    $refund->notification_number = $statment->notification_number;
                    $refund->type = '2';
                    $refund->bank_account = $request->bank_account;
                    $refund->account_owner = $request->account_owner;
                    $refund->save();
                } 
                elseif ($request->has('certificat_id')) {
                    $certificat =  Certificat::where('id',$request->certificat_id)->first();
                    $refund = new Refund; 
                    $refund->user_id = Auth::user()->id;
                    $refund->amount = $certificat->amount;
                    $refund->notification = $certificat->bank;
                    $refund->notification_number = $certificat->notification_number;
                    $refund->type = '1';
                    $refund->bank_account = $request->bank_account;
                    $refund->account_owner = $request->account_owner;
                    $refund->save();
                } 
                elseif ($request->has('document_id')) {
                    $document =  Document::where('id',$request->document_id)->first();
                    $refund = new Refund; 
                    $refund->user_id = Auth::user()->id;
                    $refund->amount = $document->amount;
                    $refund->notification = $document->bank;
                    $refund->notification_number = $document->notification_number;
                    $refund->type = '1';
                    $refund->bank_account = $request->bank_account;
                    $refund->account_owner = $request->account_owner;
                    $refund->save();
                } 
                else
                {
                    return redirect()->back()->withErrors('لم يتم رفض اي مستند مالياً حتى يتم استرداد الرسوم');
                }
            
                

                toastr()->success(trans('messages.success'));
                return redirect()->route('refunds.index');
             }
    
            catch (\Exception $e){
            return redirect()->back()->withErrors(['error' => $e->getMessage()]);
             }

    }

    
    public function show($id)
    {
        $refund = Refund::find(decrypt($id));
        return view('pages.Refunds.show',compact('refund'));
    }

    public function edit($id)
    {
        $refund = Refund::find(decrypt($id));
        return view('pages.Refunds.edit',compact('refund'));
    }

    public function update(UpdateRefundRequest $request, Refund $refund)
    {
       
    }

    public function destroy(Refund $refund)
    {
        try {

                $refund->delete();
                toastr()->error(trans('messages.Delete'));
                return redirect()->route('refunds.index');
            }
    
            catch (\Exception $e){
            return redirect()->back()->withErrors(['error' => $e->getMessage()]);
            }
    }

    public function RefundsProcess(Request $request)
    {
       
            // $validatedData = $request->validate([
            //     'notification_refund' => 'required',
            // ],[
            //     'notification_refund.required' =>'يرجي ارفقا اشعار المبلغ',
            
            // ]);
           try {
                $refund = Refund::where('id',$request->id)->first();

                $refund->emp_id = Auth::user()->id;
                $refund->stutus = $request->rdio;
                $refund->note = $request->input('note');
                $refund->refund = $request->input('refund');
                if ($request->hasFile('notification_refund')) {
                    $image = $request->file('notification_refund');
                    $filename = time() . '.' . $image->getClientOriginalExtension();
                   // $location = public_path('images/bank/' . $filename);
                    $location ='/home/eustedu/certificats.eust.edu.sd/images/bank/' . $filename;
                    Image::make($image)->resize(500, 600)->save($location);
                    $refund->notification_refund = $filename;
                } 

                $refund->save(); 

                }
                
                catch (\Exception $e){
                return redirect()->back()->withErrors(['error' => $e->getMessage()]);
                }

                toastr()->success(trans('messages.success'));
                return redirect('/refunds');

    }

    public function ExportRefunds() 
    {
        return Excel::download(new RefundsExport, 'RefundsExports.xlsx');
    }
    public function RefundsReport() 
    {
        $refunds = Refund::all();
        $refundsSum = Refund::where('stutus','1')->sum('amount');
        return view('pages.reports.refundsCount',compact('refunds','refundsSum'));
    }


}//end of controller 
