<?php

namespace App\Http\Controllers;

use App\Models\Register;
use App\Models\Record;
use App\Models\Certificat;
use App\Models\Grade;
use App\Models\Semester;
use App\Models\Statment;
use App\Http\Requests\StoreRegisterRequest;
use App\Http\Requests\UpdateRegisterRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Notification;
use App\Notifications\RegisterCreate;
use App\Notifications\RegisterResult;
use App\Notifications\RegisterPuy;
use Storage; 
use Image;

class RegisterController extends Controller
{
    function __construct()
    { 

    $this->middleware('permission:عرض السجل', ['only' => ['index']]);
    $this->middleware('permission:اضافة السجل', ['only' => ['create','store']]);
    $this->middleware('permission:تعديل السجل', ['only' => ['edit','update']]);
    $this->middleware('permission:حذف السجل', ['only' => ['destroy']]);
    $this->middleware('permission:المالية', ['only' => ['registerProcessPay']]);
    $this->middleware('permission:النتيجة', ['only' => ['registerProcessResult']]);

    }
    public function index()
    {
        //  
        if(Auth::user()->user_type == 'stu')
        {
            $registers = Register::where('user_id', Auth::user()->id)->get();

        }
        else
        {
            $registers = Register::all();
        }

        return view('pages.Registers.index',compact('registers'));
    }

   
    public function create()
    {
         
        $grades = Grade::all();
        $semesters = Semester::all();
        return view('pages.Registers.create',compact('grades','semesters'));
    }

    public function store(StoreRegisterRequest $request)
    {
      //dd($request->all());
       if(Register::where('user_id',Auth::user()->id)->exists())
        {
           return redirect()->back()->withErrors('تم التقديم لسجل اكاديمي مسبقاً');
        }
        elseif(Certificat::where('user_id',Auth::user()->id)->exists())
        {
           return redirect()->back()->withErrors('تم التقديم لأستخراج الشهادة جامعية');
        }
        elseif(Record::where('user_id',Auth::user()->id)->exists())
        {
           return redirect()->back()->withErrors('تم التقديم لأستخراج شهادة قيد');
        }
        elseif(Statment::where('user_id',Auth::user()->id)->exists())
        {
           return redirect()->back()->withErrors('تم التقديم لافادة تخرج مسبقاً');
        }

        try {
           
            $validated = $request->validated();
               
            $register = new Register; 
            $register->first_name = $request->first_name;
            $register->second_name = $request->second_name;
            $register->midell_name = $request->midell_name;
            $register->last_name = $request->last_name;
            $register->lang =  $request->lang;
            $register->amount = '50000';
            $register->notification_number =$request->notification_number;
            // $register->grade_id =  $request->grade_id;
            // $register->semester_id =  $request->semester_id;

            $register->user_id = Auth::user()->id;

            if ($request->hasFile('personal_image')) {
                $image = $request->file('personal_image');
                $filename = time() . '.' . $image->getClientOriginalExtension();
                $location = '/home/eustedu/certificats.eust.edu.sd/images/personalImage/' . $filename;
                Image::make($image)->resize(500, 500)->save($location);
                $register->personal_image = $filename;
            }  
            if ($request->hasFile('bank')) {
                $image = $request->file('bank');
                $filename = time() . '.' . $image->getClientOriginalExtension();
                $location ='/home/eustedu/certificats.eust.edu.sd/images/bank/' . $filename;
                Image::make($image)->resize(500, 600)->save($location);
                $register->bank = $filename;
            } 
            if ($request->hasFile('ssn')) {
                $image = $request->file('ssn');
                $filename = time() . '.' . $image->getClientOriginalExtension();
               $location = '/home/eustedu/certificats.eust.edu.sd/images/ssn/' . $filename;
                Image::make($image)->resize(500, 600)->save($location);
                $register->ssn = $filename;
            }  
           
            $register->save();

            $user = User::where('id',Auth::user()->id)->first();
            Notification::send($user, new \App\Notifications\RegisterCreate);

            toastr()->success(trans('messages.success'));
            return redirect()->route('registers.index');
         }
    
            catch (\Exception $e){
            return redirect()->back()->withErrors(['error' => $e->getMessage()]);
             }

    }

    public function show($id)
    {
        $register = Register::find(decrypt($id));
        return view('pages.Registers.show',compact('register'));
    }

    public function edit($id)
    {
        $grades = Grade::all();
        $semesters = Semester::all();
        $register = Register::find(decrypt($id));
        return view('pages.Registers.edit',compact('grades','semesters','register'));
    }

    public function update(UpdateRegisterRequest $request, Register $register)
    {
       
        try {
           
            $register->first_name = $request->first_name;
            $register->second_name = $request->second_name;
            $register->midell_name = $request->midell_name;
            $register->last_name = $request->last_name;
            $register->lang = $request->lang;
            // $register->grade_id =  $request->grade_id;
            // $register->semester_id =  $request->semester_id;
            $register->notification_number =$request->notification_number;

            if ($request->hasFile('personal_image')) {
                Storage::delete($register->personal_image);
                $image = $request->file('personal_image');
                $filename = time() . '.' . $image->getClientOriginalExtension();
                $location = '/home/eustedu/certificats.eust.edu.sd/images/personalImage/' . $filename;
                Image::make($image)->resize(500, 500)->save($location);
                $register->personal_image = $filename;

            }  

            if ($request->hasFile('bank')) {
                Storage::delete($register->bank);
                $image = $request->file('bank');
                $filename = time() . '.' . $image->getClientOriginalExtension();
                $location ='/home/eustedu/certificats.eust.edu.sd/images/bank/' . $filename;
                Image::make($image)->resize(500, 600)->save($location);
                $register->bank = $filename;
            } 
            if ($request->hasFile('ssn')) {
                Storage::delete($register->ssn);
                $image = $request->file('ssn');
                $filename = time() . '.' . $image->getClientOriginalExtension();
                $location = '/home/eustedu/certificats.eust.edu.sd/images/ssn/' . $filename;
                Image::make($image)->resize(500, 600)->save($location);
                $register->ssn = $filename;
            } 
            
            $register->save();
                
            toastr()->success(trans('messages.Update')); 
            return redirect()->route('registers.index');
            }
            catch (\Exception $e){
                return redirect()->back()->withErrors(['error' => $e->getMessage()]);
                }

    }

    
    public function destroy(Request $request)
    {
        try {
           
            $register = Register::where('id',$request->id)->first();
             $register->delete();
             toastr()->error(trans('messages.Delete'));
            return redirect()->route('registers.index');
        }

        catch (\Exception $e){
        return redirect()->back()->withErrors(['error' => $e->getMessage()]);
        }
    }

    public function registerProcessResult(Request $request)
    {
       
            $validatedData = $request->validate([
                'rdio' => 'required',
            ],[

                'rdio.required' =>'يرجي تحديد الحالة الأكاديمية للسجل',
            
            ]);
           try {
                $register = Register::where('id',$request->id)->first();
                $register->update([
                'r_status' => $request->rdio,
                'r_note' => $request->note,
                'acdimec_user'=> Auth::user()->id,
                    ]);
                }
                
                catch (\Exception $e){
                return redirect()->back()->withErrors(['error' => $e->getMessage()]);
                }

                $user = User::where('id',$register->user_id)->first();
                Notification::send($user, new \App\Notifications\RegisterResult);
                
                toastr()->success(trans('messages.success'));
                return redirect('/registers');

    }

    public function registerProcessPay(Request $request)
    {
       
            $validatedData = $request->validate([
                'rdio' => 'required',
            ],[

                'rdio.required' =>'يرجي تحديد الحالة المالية للشهادة',
            
            ]);
           try {
                $register = Register::where('id',$request->id)->first();
                $register->update([
                'f_status' => $request->rdio,
                'f_note' => $request->note,
                'bank_user'=> Auth::user()->id,
                    ]);
                }
                
                catch (\Exception $e){
                return redirect()->back()->withErrors(['error' => $e->getMessage()]);
                }

                $user = User::where('id',$register->user_id)->first();
                Notification::send($user, new \App\Notifications\RegisterPuy);

                toastr()->success(trans('messages.success'));
                return redirect('/registers');

    }
    public function ArchiveRegister() 
    {
        $registers = Register::onlyTrashed()->get();
        return view('pages.Registers.ArchiveRegister',compact('registers'));
       
    }
    
     public function RestoeRegister(Request $request) 
    {
       $id=$request->id;
        $Register = Register::withTrashed()->where('id', $id)->restore();
      
        toastr()->success(trans('messages.success'));
        return redirect()->back();
    }
    public function CommentRegister(Request $request)
    {
       
           try {
                $register = Register::where('id',$request->id)->first();
                $register->update([
                'comments' => $request->comments,
               
                    ]);
                }
                
                catch (\Exception $e){
                return redirect()->back()->withErrors(['error' => $e->getMessage()]);
                }

                // $user = User::where('id',$register->user_id)->first();
                // Notification::send($user, new \App\Notifications\RegisterPuy);

                toastr()->success(trans('messages.success'));
                return redirect('/registers');

    }


}//end of controller
