<?php

namespace App\Http\Controllers;
use App\Models\Certificat;
use App\Models\Statment;
use App\Models\Register;
use App\Models\Dept;
use App\Models\User;
use App\Models\Record;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Document;
use App\Models\Refund;

class ReportsController extends Controller
{
    function __construct()
    { 

    $this->middleware('permission:التقارير', ['only' => ['create','index']]);

    }
    public function index(Request $request)
    {
        
     //return view('pages.reports.index'); 
    
    }
 
    
    public function create(Request $request)
    {
        return view('pages.reports.create');
    }

    public function student(Request $request)
    {
        $depts =  Dept::with('users')->get();
        return view('pages.reports.students',compact('depts'));
    }

    public function statmentReport(Request $request)
    {
        $allStatment = Statment::all()->count();
        $complateStatment = Statment::where('f_status','1')
        ->where('r_status','1')
        ->count();

        $PayRejectStatment = Statment::where('f_status','2')->count();
        $ResultRejectStatment = Statment::where('r_status','2')->count();

        $depts =  Dept::with('statments')->get();
        //dd( $depts);
        return view('pages.reports.statments',compact('depts','allStatment','complateStatment','PayRejectStatment','ResultRejectStatment'));
    }

    public function records(Request $request)
    {
        return view('pages.reports.create');
    }

    public function certificatsReport(Request $request)
    {
        $allCertificat = Certificat::all()->count();

        $complateCertificat = Certificat::where('f_status','1')
        ->where('r_status','1')
        ->count();

        $PayRejectCertificat = Certificat::where('f_status','2')->count();
        $ResultRejectCertificat = Certificat::where('r_status','2')->count();

        $depts =  Dept::with('certificats')->get();


        return view('pages.reports.certificat',compact('allCertificat','complateCertificat','PayRejectCertificat','ResultRejectCertificat','depts'));
    }

    public function recordsReport(Request $request)
    {
        $allRecord = Record::all()->count();

        $complateRecord = Record::where('f_status','1')
        ->where('r_status','1')
        ->count();

        $PayRejectRecord = Record::where('f_status','2')->count();
        $ResultRejectRecord = Record::where('r_status','2')->count();

        $depts =  Dept::with('records')->get();


        return view('pages.reports.record',compact('allRecord','complateRecord','PayRejectRecord','ResultRejectRecord','depts'));
    }

   
    public function store(Request $request)
    {
        //
    }

   
    public function show($id)
    {
        $centerData = DB::table('log_activities')->get();
    }

    public function activities()
    {
        $activities = DB::table('log_activities')->orderBy('Created_at','DESC')->get();
       
        return view('pages.reports.activities',compact('activities'));
    }

   
    public function certificatsCount()
    {
        $certificats = Certificat::all();
        $certificatsSum = Certificat::where('f_status','1')->sum('amount');
        return view('pages.reports.certificatsCount',compact('certificats','certificatsSum'));
    }

    public function statmentsCount()
    {
        $statments = Statment::all();
        return view('pages.reports.statmentsCount',compact('statments'));
    }

    public function recordsCount()
    {
        $records = Record::all();
        return view('pages.reports.recordsCount',compact('records'));
    }

    public function registersCount()
    {
        $registers = Register::all();
        return view('pages.reports.registersCount',compact('registers'));
    }

    public function certificatsPrint()
    {
        $certificats = Certificat::where('f_status','1')
        ->where('r_status','1')
        ->where('print','0')
        ->get();
        return view('pages.reports.certificatsPrint',compact('certificats'));
    }

    public function CertificatesComplate()
    {
        $certificats = Certificat::where('f_status','1')
        ->where('r_status','1')
        ->where('print','1')
        ->get();
        return view('pages.reports.CertificatesComplate',compact('certificats'));
    }
    
    public function documentsCount()
    {
        $documents = Document::all();
        $documentSum = Document::where('f_status','1')->sum('amount');
        return view('pages.reports.documentsCount',compact('documents','documentSum'));
    }
    
    public function GenralFinancialReport()
    {
       
        $documentSum = Document::where('f_status','1')->sum('amount');
        $certificatsSum = Certificat::where('f_status','1')->sum('amount');
        $refund = Refund::where('stutus','1')->sum('amount');
       
        return view('pages.reports.GenralFinancialReport',compact('documentSum','certificatsSum','refund'));
    }
     public function CertificatesRadyToDelver()
    {
        
        $certificats = Certificat::where('f_status','1')
        ->where('r_status','1')
        ->where('print','1')
        ->where('delivery_status','0')
        ->get();
        
        return view('pages.reports.CertificatesRadyToDelver',compact('certificats'));
    }
    public function update(Request $request, $id)
    {
        //
    }

   
    public function destroy($id)
    {
        //
    }
}
