<?php

namespace App\Http\Controllers;

use App\Models\Statment;
use App\Models\Dept;
use App\Models\Year;
use App\Models\Certificat;
use App\Models\Record;
use App\Models\Register;
use App\Http\Requests\StoreStatmentRequest;
use App\Http\Requests\UpdateStatmentRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Storage; 
use Image;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Notification;
use App\Models\User;
use App\Notifications\StatmentCreate;
use App\Notifications\StatmentResult;
use App\Notifications\StatmentPuy;

class StatmentController extends Controller
{
    function __construct()
    { 

    $this->middleware('permission:عرض افادة', ['only' => ['index']]);
    $this->middleware('permission:اضافة افادة', ['only' => ['create','store']]);
    $this->middleware('permission:تعديل افادة', ['only' => ['edit','update']]);
    $this->middleware('permission:حذف افادة', ['only' => ['destroy']]);
    $this->middleware('permission:المالية', ['only' => ['processpay']]);
    $this->middleware('permission:النتيجة', ['only' => ['processresult']]);

    }
    
    public function index()
    {


        if(Auth::user()->user_type == 'stu')
        {
            $statments = Statment::where('user_id', Auth::user()->id)->get();

        }
        else
        {
            $statments = Statment::all();
        }

        return view('pages.Statments.index',compact('statments'));
    }

    public function create()
    {
        $depts = Dept::all();
        return view('pages.Statments.create',compact('depts'));
    }

    public function store(StoreStatmentRequest $request)
    {
        if(Statment::where('user_id',Auth::user()->id)->exists())
        {
           return redirect()->back()->withErrors('تم التقديم مسبقاً');
        }
        elseif(Certificat::where('user_id',Auth::user()->id)->exists())
        {
           return redirect()->back()->withErrors('تم التقديم لأستخراج الشهادة جامعية');
        }
        elseif(Register::where('user_id',Auth::user()->id)->exists())
        {
           return redirect()->back()->withErrors('تم التقديم لسجل اكاديمي مسبقاً');
        }
        elseif(Record::where('user_id',Auth::user()->id)->exists())
        {
           return redirect()->back()->withErrors('تم التقديم لأستخراج شهادة قيد');
        }

        try {
           
            $validated = $request->validated();
           
            $statment = new Statment; 
            $statment->first_name = $request->first_name;
            $statment->second_name = $request->second_name;
            $statment->midell_name = $request->midell_name;
            $statment->last_name = $request->last_name;
            $statment->dept_id = Auth::user()->dept_id;
            $statment->user_id = Auth::user()->id;
            $statment->notification_number =$request->notification_number;
            $statment->amount = '50000';

            if ($request->hasFile('bank')) {
                $image = $request->file('bank');
                $filename = time() . '.' . $image->getClientOriginalExtension();
                $location ='/home/eustedu/certificats.eust.edu.sd/images/statment/' . $filename;
                Image::make($image)->resize(500, 600)->save($location);
                $statment->image = $filename;
            } 
           
            $statment->save();
            
            $user = User::where('id',Auth::user()->id)->first();
            Notification::send($user, new \App\Notifications\StatmentCreate);

            toastr()->success(trans('messages.success'));
            return redirect()->route('statments.index');
         }
    
            catch (\Exception $e){
            return redirect()->back()->withErrors(['error' => $e->getMessage()]);
             }
    }

    public function show($id)
    {
        $statment = Statment::find(decrypt($id));
        return view('pages.Statments.show',compact('statment'));
    }

    public function edit($id)
    {
        $statment = Statment::find(decrypt($id));
        $depts =  Dept::all();
       
        return view('pages.Statments.edit',compact('statment','depts'));
    }

    public function update(UpdateStatmentRequest $request, Statment $statment)
    {
        try {
           

            $statment->first_name = $request->first_name;
            $statment->second_name = $request->second_name;
            $statment->midell_name = $request->midell_name;
            $statment->last_name = $request->last_name;
            $statment->notification_number =$request->notification_number;
               
            if ($request->hasFile('bank')) {
                Storage::delete($statment->image);
                $image = $request->file('bank');
                $filename = time() . '.' . $image->getClientOriginalExtension();
                $location ='/home/eustedu/certificats.eust.edu.sd/images/statment/' . $filename;
                Image::make($image)->resize(500, 600)->save($location);
                $statment->image = $filename;
            } 
            
            $statment->save();
                
            toastr()->success(trans('messages.Update')); 
            return redirect()->route('statments.index');
            }
            catch (\Exception $e){
                return redirect()->back()->withErrors(['error' => $e->getMessage()]);
                }
    }

    public function destroy(Request $request)
    {
        try {
          
            $statment = Statment::where('id',$request->id)->first();
             $statment->delete();
             toastr()->error(trans('messages.Delete'));
            return redirect()->route('statments.index');
        }

        catch (\Exception $e){
        return redirect()->back()->withErrors(['error' => $e->getMessage()]);
        }

      
    }
    
public function processpay(Request $request)
{
        $validatedData = $request->validate([
            'rdio' => 'required',
        ],[

            'rdio.required' =>'يرجي تحديد الحالة المالية للافادة',
        
        ]);
    
       try {
            $statment = Statment::where('id',$request->id)->first();
            $statment->update([
            'f_status' => $request->rdio,
            'f_note' => $request->note,
                ]);
            }
            
            catch (\Exception $e){
            return redirect()->back()->withErrors(['error' => $e->getMessage()]);
            }

            $user = User::where('id',$statment->user_id)->first();
            Notification::send($user, new \App\Notifications\StatmentPuy);

            toastr()->success(trans('messages.success'));
            return redirect('/statments');

}

public function processresult(Request $request)
{
   
        $validatedData = $request->validate([
            'rdio' => 'required',
        ],[

            'rdio.required' =>'يرجي تحديد الحالة الأكاديمية للافادة',
          
        ]);
    
       try {
            $statment = Statment::where('id',$request->id)->first();
            $statment->update([
            'r_status' => $request->rdio,
            'r_note' => $request->note,
                ]);
            }
            
            catch (\Exception $e){
            return redirect()->back()->withErrors(['error' => $e->getMessage()]);
            }

            $user = User::where('id',$statment->user_id)->first();
            Notification::send($user, new \App\Notifications\StatmentResult);

            toastr()->success(trans('messages.success'));
            return redirect('/statments');

}

   public function ArchiveStatment() 
    {
        $statments = Statment::onlyTrashed()->get();
        return view('pages.Statments.ArchiveStatment',compact('statments'));
       
    }

   public function RestorStatment(Request $request) 
    {
       $id=$request->id;
        $Statment = Statment::withTrashed()->where('id', $id)->restore();
      
        toastr()->success(trans('messages.success'));
        return redirect()->back();
    }
    public function CommentStatment(Request $request)
    {
           try {
               
                $statment = Statment::where('id',$request->id)->first();
                $statment->update([
                    'comments' => $request->comments,
                    ]);
                }

                catch (\Exception $e){
                return redirect()->back()->withErrors(['error' => $e->getMessage()]);
                }

                
                // $user = User::where('id',$certificat->user_id)->first();
                //  Notification::send($user, new \App\Notifications\CertificatProcessResult);

                toastr()->success(trans('messages.success'));
                return redirect('/statments');

    }

}//end of controller 
