<?php

namespace App\Http\Controllers;

use App\Models\Student;
use App\Models\User;
use App\Http\Requests\StoreStudentRequest;
use App\Http\Requests\UpdateStudentRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;


class StudentController extends Controller
{
    function __construct()
{ 

$this->middleware('permission:عرض طالب', ['only' => ['index']]);
$this->middleware('permission:اضافة طالب', ['only' => ['create','store']]);
$this->middleware('permission:تعديل طالب', ['only' => ['edit','update']]);
$this->middleware('permission:حذف طالب', ['only' => ['destroy']]);

}

    public function index()
    {
        $users =  User::where('user_type','stu')->get();
        
        return view('pages.Students.index',compact('users'));
    }

   
    public function Notverified()
    {
        $users =  User::where('user_type','stu')
        ->whereNULL('email_verified_at')
        ->get();
        
        return view('pages.Students.Notverified',compact('users'));
    }

    public function ArchiveStudent() 
    {
        $users = User::onlyTrashed()->get();
        return view('pages.Students.ArchiveUser',compact('users'));
       
    }
    

    public function create()
    {
        //
    }

    
    public function store(StoreStudentRequest $request)
    {
        //
    }

    
    public function show(Student $student)
    {
        //
    }

   
    public function edit(Student $student)
    {
        //
    }

 
    public function update(UpdateStudentRequest $request, Student $student)
    {
        //
    }

    
    public function destroy(Request $request)
    {
        User::destroy($request->id);
        toastr()->error(trans('messages.Delete'));
        return redirect()->route('students.index');
    }
     public function RestoeStudent(Request $request) 
    {
       $id=$request->id;
        $user = User::withTrashed()->where('id', $id)->restore();
      
        toastr()->success(trans('messages.success'));
        return redirect()->back();
    }
}
