<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreDeliveryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'first_name' => 'required',
            'second_name' => 'required',
            'midell_name' => 'required',
            'last_name' => 'required',
            'docType' => 'required',
            'ssn' => 'required|image|mimes:jpg,png,jpeg',
        ];
    }
    public function messages()
    {
        return [
            'first_name'=> 'الاسم الاول مطلوب',
            'second_name.required' => 'الاسم الثاني مطلوب',
            'midell_name.required' => 'الاسم الثالث مطلوب',
            'last_name'=> 'الاسم الرابع مطلوب',
            'ssn.required' => 'اثبات الشخصية مطلوب',
            'ssn.image' => 'اثبات الشخصية يجب ان يكون نوع الملف صورة',
            'ssn.mimes' => 'اثبات الشخصية يجب ان يكون نوع الملف صورة',
           'docType.required'=> 'يجب تحديد نوع المستند',
        ];
    }
}
