<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreDocumentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'notification_number' => 'required|integer|unique:documents,notification_number',
            'bank' => 'required|image|mimes:jpg,png,jpeg',
            'type' => 'required',
        ];
    }
    public function messages()
    {
        return [
           
            'bank.required' => 'اشعار البنك مطلوب',
            //'dept_id.required' => 'يرجى اختيار القسم',
            'type.required' => 'يرجى اختيار نوع التوثيق',
            'bank.image' => 'اشعار البنك يجب ان يكون نوع الملف صورة',
            'bank.mimes' => 'اشعار البنك يجب ان يكون نوع الملف صورة',
            'notification_number.required' => 'رقم العملية مطلوب',
            'notification_number.integer' => 'رقم العملية يجب ان يكون ارقام',
            'notification_number.unique' => 'رقم العملية مستخدم بالفعل',
           
        ];
    }
}
