<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreRefundRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'bank_account' => 'required|integer',
            'account_owner' => 'required',
        ];
    }

    public function messages()
    {
        return [
            'bank_account.required' => trans('validation.required'),
            'bank_account.integer' => trans('validation.integer'),
            'account_owner.required' => trans('validation.required'),
        ];
    }
}
