<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreStatmentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'first_name' => 'required',
            'second_name' => 'required',
            'midell_name' => 'required',
            'last_name' => 'required',
            //'dept_id' => 'required',
            'bank' => 'required|mimes:jpg,png,jpeg',
            'notification_number' => 'required|integer|unique:certificats,notification_number',
          
        ];
    }
    public function messages()
    {
        return [
            'first_name.required' =>  'يرجى ادخال الاسم الاول',
            'second_name.required' => 'يرجى ادخال الاسم الثاني',
            'midell_name.required' => 'يرجى ادخال الاسم الثالث',
            'last_name.required' => 'يرجى ادخال الاسم الرابع',
           // 'dept_id.required' => 'يرجى اختيار القسم',
            'bank.required' => 'اشعار البنك مطلوب',
            'bank.mimes' => 'اشعار البنك يجب ان تكون نوع الملف صورة',
            'notification_number.required' => 'رقم العملية مطلوب',
            'notification_number.integer' => 'رقم العملية يجب ان يكون ارقام',
            'notification_number.unique' => 'رقم العملية مستخدم بالفعل',
        ];
    }
}
