<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateRegisterRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'first_name' => 'required',
            'second_name' => 'required',
            'midell_name' => 'required',
            'last_name' => 'required',
            'personal_image' => 'required|image|mimes:jpg,png,jpeg',
            'bank' => 'required|image|mimes:jpg,png,jpeg',
            'ssn' => 'required|image|mimes:jpg,png,jpeg',
            'lang' => 'required',
            // 'grade_id' => 'required',
            // 'semester_id' => 'required',
            'notification_number' => 'required|integer|unique:certificats,notification_number',
         
        ];
    }
    public function messages()
    {
        return [
            'first_name'=> 'الاسم الاول مطلوب',
            'second_name.required' => 'الاسم الثاني مطلوب',
            'midell_name.required' => 'الاسم الثالث مطلوب',
            'last_name'=> 'الاسم الرابع مطلوب',
            'personal_image.required' => 'الصورة الشخصية مطلوبة',
            'bank.required' => 'اشعار البنك مطلوب',
            'ssn.required' => 'اثبات الشخصية مطلوب',
            'personal_image.image' => 'الصورة الشخصية يجب ان يكون نوع الملف صورة',
            'bank.image' => 'اشعار البنك يجب ان يكون نوع الملف صورة',
            'ssn.image' => 'اثبات الشخصية يجب ان يكون نوع الملف صورة',
            'personal_image.mimes' => 'الصورة الشخصية يجب ان يكون نوع الملف صورة',
            'bank.mimes' => 'اشعار البنك يجب ان يكون نوع الملف صورة',
            'ssn.mimes' => 'اثبات الشخصية يجب ان يكون نوع الملف صورة',
            'lang.required' => 'يرجى تحديد اللغة',
            // 'grade_id.required' => 'يرجى تحديد المستوى',
            // 'semester_id.required' => 'يرجى تحديد الفصل الدراسي',
            'notification_number.required' => 'رقم العملية مطلوب',
            'notification_number.integer' => 'رقم العملية يجب ان يكون ارقام',
            'notification_number.unique' => 'رقم العملية مستخدم بالفعل',
           
        ];
    }
}
