<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Translatable\HasTranslations;
use App\Models\Dept;
use App\Models\User;
use App\Models\Document;
use App\Models\Delivery;


class Certificat extends Model
{
    use HasFactory,SoftDeletes,HasTranslations;
   
    protected $casts = [
        'certificat_type' => 'array',
        'first_name' => 'array',
        'second_name' => 'array',
        'midell_name' => 'array',
        'last_name' => 'array',
        'lang' => 'array',
    ];
    protected $dates = ['deleted_at'];
    protected $guarded = [];
    public $translatable = ['name'];
   
    public function Dept()
    {
        return $this->belongsTo(Dept::class);
    }
    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function document()
    {
        return $this->belongsTo(Document::class);
    }
    // public function deliveries()
    // {
    //      return $this->hasMany(Delivery::class);
    // } 

}
