<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Translatable\HasTranslations;
use App\Models\Grade;
use App\Models\Subject;
use App\Models\User;

class Semester extends Model
{
    use HasFactory;
    use HasTranslations;
    use SoftDeletes;

   
    protected $dates = ['deleted_at'];
    protected $guarded = [];
    
    public $translatable = ['name'];
    public $timestamps = true;

    public function grade()
    {
        return $this->belongsTo(Grade::class);
    }
    public function subjects()
    {
         return $this->hasMany(Subject::class);
    } 
    public function users()
    {
        return $this->hasMany(User::class); 
    }


}
