<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Translatable\HasTranslations;
use App\Models\Dept;
use App\Models\Semester;

class Subject extends Model
{
    use HasFactory;
    use HasTranslations;
    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $guarded = [];
    public $translatable = ['name'];

    public function dept()  
    {
     return $this->belongsTo(Dept::class); 
    } 

    public function semester()
    {
        return $this->belongsTo(Semester::class);
    }


}
