<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('registers', function (Blueprint $table) {
            $table->id();
            $table->string('first_name')->nullable();
            $table->string('second_name')->nullable();
            $table->string('midell_name')->nullable();
            $table->string('last_name')->nullable(); 
            $table->string('personal_image')->nullable();
            $table->string('bank')->nullable();
            $table->string('ssn')->nullable();
            $table->string('lang');
            $table->string('f_status')->default('0');
            $table->string('r_status')->default('0');
            $table->string('f_note')->nullable();
            $table->string('r_note')->nullable();
            $table->string('status')->nullable();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('grade_id')->nullable();
            $table->unsignedBigInteger('semester_id')->nullable();
            $table->bigInteger('notification_number');
            $table->Integer('acdimec_user')->nullable();
            $table->Integer('bank_user')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('registers');
    }
};
