<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Dept;
use Illuminate\Support\Facades\DB;

class DeptSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */ 
    public function run()
    {
        DB::table('depts')->delete();
        $depts = [
            ['en'=> 'Information Technology', 'ar'=> 'تقنية معلومات'],
            ['en'=> 'Computer Saince', 'ar'=> 'علوم حاسوب'],
            ['en'=> 'General information systems', 'ar'=> 'نظم المعلومات العامة'],
            ['en'=> 'Architecture and planning', 'ar'=> 'هندسة العمارة و التخطيط'],
            ['en'=> 'Administrative Sciences (Accounting)', 'ar'=> 'العلوم الأدارية (محاسبة)'],
            ['en'=> 'Administrative Sciences (Management)', 'ar'=> 'العلوم الأدارية ( أدارة)'],
            ['en'=> 'Economics and Banking Sciences (Economics)', 'ar'=> 'الاقتصاد و العلوم المصرفية (أقتصاد)'],
            ['en'=> 'Economics and banking sciences (banking sciences)', 'ar'=> 'الاقتصاد و العلوم المصرفية (علوم  مصرفية)'],
            ['en'=> 'Specialized Information Systems (Banking)', 'ar'=> 'نظم المعلومات المتختصصة (مصرفية)'],
            ['en'=> 'Specialized information systems (administrative)', 'ar'=> 'نظم المعلومات المتختصصة (أدارية)'],
            ['en'=> 'Specialized information systems (accounting)', 'ar'=> 'نظم المعلومات المتختصصة (محاسبية)'],
            ['en'=> 'English', 'ar'=> 'لغة انجليزية'],
            ['en'=> 'Information Technology Diploma', 'ar'=> 'دبلوم تقنية معلومات'],
            ['en'=> 'Information Systems Diploma', 'ar'=> 'دبلوم نظم معلومات'],
            ['en'=> 'Networking diploma', 'ar'=> 'دبلوم شبكات'],
            ['en'=> 'Accounting Information Systems Diploma', 'ar'=> 'دبلوم نظم المعلومات المحاسبية'],
           
        ];

        foreach ($depts as $dept) {
            Dept::create(['name' => $dept]);
        }
      
    }
}
