<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Grade;
use Illuminate\Support\Facades\DB;
use App\Models\Semester;

class SemesterSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('semesters')->delete();
        $semesters = [
            ['en'=> 'First Grade', 'ar'=> 'الفصل الاول'],
            ['en'=> 'Second Grade', 'ar'=> 'الفصل الثاني'],
            ['en'=> 'Thard Grade', 'ar'=> 'الفصل الثالث'],
            ['en'=> 'Forth Grade', 'ar'=> 'الفصل الرابع'],
            ['en'=> 'Five Grade', 'ar'=> 'الفصل الخامس'],
            ['en'=> 'six Grade', 'ar'=> 'الفصل السادس'],
            ['en'=> 'seven Grade', 'ar'=> 'الفصل السابع'],
            ['en'=> 'eith Grade', 'ar'=> 'الفصل الثامن'],
            ['en'=> 'nighe Grade', 'ar'=> 'الفصل التاسعة'],
            ['en'=> 'ten Grade', 'ar'=> 'الفصل العاشر'],
        ];

        foreach ($semesters as $semester) {
            Semester::create(['name' => $semester]);
        }
    }
}
