@extends('layouts.master')
@section('css')
    @toastr_css
    <link href="{{ URL::asset('assets/plugins/fileuploads/css/fileupload.css') }}" rel="stylesheet" type="text/css" />
    <!---Internal Fancy uploader css-->
    <link href="{{ URL::asset('assets/plugins/fancyuploder/fancy_fileupload.css') }}" rel="stylesheet" />
@section('title')
{{ trans('Certificat_trans.title_page') }}
@stop
@endsection
@section('page-header')
    <!-- breadcrumb -->
@section('PageTitle')
{{ trans('Certificat_trans.title_page') }} 
@stop
<!-- breadcrumb -->
@endsection
@section('content')
    <!-- row -->
    <div class="row">
        <div class="col-md-12 mb-30">
            <div class="card card-statistics h-100">
                <div class="card-body">

                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                        {{-- <form method="post"  action="{{ route('certificats.store') }}" autocomplete="off" files="ture"> --}}
                            {!! Form::open(['url'=>'/changePassword', 'method'=>'POST','autocomplete'=>'off','class'=>'form']) !!}  
                            {{csrf_field()}}
                            @csrf
                            <div class="row">
                              
                                    <div class="parsley-input col-md-6" id="fnWrapper">
                                        <label> {{ trans('main_trans.current_password') }}: <span class="tx-danger">*</span></label>
                                        <input id="current-password" type="password" class="form-control" name="current-password" autocomplete="off" required>
                                        
                                    </div>
                                
                            </div>

                            <div class="row">
                                <div class="parsley-input col-md-6" id="fnWrapper">
                                    <label>  {{ trans('main_trans.new_password') }}: <span class="tx-danger">*</span></label>
                                    <input id="new-password" type="password" class="form-control" name="new-password" required>
                                </div>
                            </div>

                            <div class="row">
                                <div class="parsley-input col-md-6" id="fnWrapper">
                                    <label> {{ trans('main_trans.confirm_password') }}: <span class="tx-danger">*</span></label>
                                    <input id="new-password-confirm" type="password" class="form-control" name="new-password_confirmation" required>
                                </div>
                            </div><br>

                           
                                <div class="d-flex justify-content-center">
                                    <button type="submit" class="btn btn-primary btn-lg">{{trans('main_trans.update')}}</button>
                                </div>
                            
                            {!! Form::close() !!}

                </div>
            </div>
        </div>
    </div>
    <!-- row closed -->
@endsection
@section('js')
    @toastr_js
    @toastr_render
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/file-upload.js') }}"></script>
    <!--Internal Fancy uploader js-->
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.ui.widget.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.iframe-transport.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fancy-fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/fancy-uploader.js') }}"></script>
@endsection
