<!DOCTYPE html>
<html lang="en">
<title>{{ trans('main_trans.Dashboard') }}</title>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="keywords" content="كلية الامارات للعلوم و التكنولوجيا" />
    <meta name="description" content="كلية الامارات للعلوم و التكنولوجيا - نظام الشهادات" />
    <meta name="author" content="www.eust.edu.sd" />
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
    @include('layouts.head')
</head>

<body>

    <div class="wrapper">

        <!--=================================
 preloader -->

        <div id="pre-loader">
            <img src="assets/images/pre-loader/loader-01.svg" alt="">
        </div>

        <!--=================================
 preloader -->

        @include('layouts.main-header')

        @include('layouts.main-sidebar')

        <!--=================================
 Main content -->
        <!-- main-content -->
        <div class="content-wrapper">
            <div class="page-title">
               
            </div>
            <!-- widgets -->
            @can('isAdmin')
            <div class="row">
                <div class="col-xl-3 col-lg-6 col-md-6 mb-30">
                    <div class="card card-statistics h-100">
                        <div class="card-body">
                            <div class="clearfix">
                                <div class="float-left">
                                    <span class="text-danger">
                                        <i class="fa fa-user-o highlight-icon" aria-hidden="true"></i>
                                    </span>
                                </div>
                                <div class="float-right text-right">
                                    <p class="card-text text-dark">{{ trans('main_trans.student') }}</p>
                                    <h4>65,650</h4>
                                </div>
                            </div>
                            
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 mb-30">
                    <div class="card card-statistics h-100">
                        <div class="card-body">
                            <div class="clearfix">
                                <div class="float-left">
                                    <span class="text-warning">
                                        <i class="ti-id-badge highlight-icon" aria-hidden="true"></i>
                                    </span>
                                </div>
                                <div class="float-right text-right">
                                    <p class="card-text text-dark">{{ trans('main_trans.Order') }}</p>
                                    <h4>656</h4>
                                </div>
                            </div>
                           
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 mb-30">
                    <div class="card card-statistics h-100">
                        <div class="card-body">
                            <div class="clearfix">
                                <div class="float-left">
                                    <span class="text-success">
                                        <i class="fa fa-server highlight-icon" aria-hidden="true"></i>
                                    </span>
                                </div>
                                <div class="float-right text-right">
                                    <p class="card-text text-dark">{{ trans('Depts_trans.title_page') }}</p>
                                    <h4>13</h4>
                                </div>
                            </div>
                           
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 mb-30">
                    <div class="card card-statistics h-100">
                        <div class="card-body">
                            <div class="clearfix">
                                <div class="float-left">
                                    <span class="text-primary">
                                        <i class="fa fa-user highlight-icon" aria-hidden="true"></i>
                                    </span>
                                </div>
                                <div class="float-right text-right">
                                    <p class="card-text text-dark">{{ trans('Users_trans.user') }}</p>
                                    <h4>8</h4>
                                </div>
                            </div>
                         
                        </div>
                    </div>
                </div>
            </div>
            @endcan
            @can('isEmp')
            <div class="row">
                <div class="col-xl-3 col-lg-6 col-md-6 mb-30">
                    <div class="card card-statistics h-100">
                        <div class="card-body">
                            <div class="clearfix">
                                <div class="float-left">
                                    <span class="text-danger">
                                        <i class="fa fa-user-o highlight-icon" aria-hidden="true"></i>
                                    </span>
                                </div>
                                <div class="float-right text-right">
                                    <p class="card-text text-dark">{{ trans('main_trans.student') }}</p>
                                    <h4>65,650</h4>
                                </div>
                            </div>
                            
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 mb-30">
                    <div class="card card-statistics h-100">
                        <div class="card-body">
                            <div class="clearfix">
                                <div class="float-left">
                                    <span class="text-warning">
                                        <i class="ti-id-badge highlight-icon" aria-hidden="true"></i>
                                    </span>
                                </div>
                                <div class="float-right text-right">
                                    <p class="card-text text-dark">{{ trans('main_trans.Order') }}</p>
                                    <h4>656</h4>
                                </div>
                            </div>
                           
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 mb-30">
                    <div class="card card-statistics h-100">
                        <div class="card-body">
                            <div class="clearfix">
                                <div class="float-left">
                                    <span class="text-success">
                                        <i class="fa fa-server highlight-icon" aria-hidden="true"></i>
                                    </span>
                                </div>
                                <div class="float-right text-right">
                                    <p class="card-text text-dark">{{ trans('Depts_trans.title_page') }}</p>
                                    <h4>13</h4>
                                </div>
                            </div>
                           
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 mb-30">
                    <div class="card card-statistics h-100">
                        <div class="card-body">
                            <div class="clearfix">
                                <div class="float-left">
                                    <span class="text-primary">
                                        <i class="fa fa-user highlight-icon" aria-hidden="true"></i>
                                    </span>
                                </div>
                                <div class="float-right text-right">
                                    <p class="card-text text-dark">{{ trans('Users_trans.user') }}</p>
                                    <h4>8</h4>
                                </div>
                            </div>
                         
                        </div>
                    </div>
                </div>
            </div>
            @endcan
            <!-- Orders Status widgets-->
            {{-- <div class="row">
                <div class="col-xl-4 mb-30">
                    <div class="card card-statistics h-100">
                        <!-- action group -->
                        <div class="btn-group info-drop">
                            <button type="button" class="dropdown-toggle-split text-muted" data-toggle="dropdown"
                                aria-haspopup="true" aria-expanded="false"><i class="ti-more"></i></button>
                            <div class="dropdown-menu">
                                <a class="dropdown-item" href="#"><i class="text-primary ti-reload"></i>Refresh</a>
                                <a class="dropdown-item" href="#"><i class="text-secondary ti-eye"></i>View
                                    all</a>
                            </div>
                        </div>
                        <div class="card-body">
                            <h5 class="card-title">Market summary</h5>
                            <h4>$50,500 </h4>
                            <div class="row mt-20">
                                <div class="col-4">
                                    <h6>Apple</h6>
                                    <b class="text-info">+ 82.24 % </b>
                                </div>
                                <div class="col-4">
                                    <h6>Instagram</h6>
                                    <b class="text-danger">- 12.06 % </b>
                                </div>
                                <div class="col-4">
                                    <h6>Google</h6>
                                    <b class="text-warning">+ 24.86 % </b>
                                </div>
                            </div>
                        </div>
                        <div id="sparkline2" class="scrollbar-x text-center"></div>
                    </div>
                </div>
                <div class="col-xl-8 mb-30">
                    <div class="card h-100">
                        <div class="btn-group info-drop">
                            <button type="button" class="dropdown-toggle-split text-muted" data-toggle="dropdown"
                                aria-haspopup="true" aria-expanded="false"><i class="ti-more"></i></button>
                            <div class="dropdown-menu">
                                <a class="dropdown-item" href="#"><i class="text-primary ti-reload"></i>Refresh</a>
                                <a class="dropdown-item" href="#"><i class="text-secondary ti-eye"></i>View
                                    all</a>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="d-block d-md-flexx justify-content-between">
                                <div class="d-block">
                                    <h5 class="card-title">Site Visits Growth </h5>
                                </div>
                                <div class="d-flex">
                                    <div class="clearfix mr-30">
                                        <h6 class="text-success">Income</h6>
                                        <p>+584</p>
                                    </div>
                                    <div class="clearfix  mr-50">
                                        <h6 class="text-danger"> Outcome</h6>
                                        <p>-255</p>
                                    </div>
                                </div>
                            </div>
                            <div id="morris-area" style="height: 320px;"></div>
                        </div>
                    </div>
                </div>
            </div> --}}
          
          

            <div class="calendar-main mb-30">
                <div class="row">
                    {{-- <div class="col-lg-6">
                        <div class="row">
                            <div class="col-12 sm-mb-30">
                                {{ trans('main_trans.hello') }} {{ Auth::user()->first_name }}
                            </div>
                        </div>  
                        <div class="row">
                            <div class="col-12 sm-mb-30">
                                <span class="text-success">{{ trans('main_trans.info') }}</span>
                            </div>
                        </div>
                        
                        <div class="row"> 
                            <div class="col-12 sm-mb-30">
                               <span><b >{{ trans('main_trans.text1') }} :</b>
                            </div>
                        </div>
                        <div class="row"> 
                            <div class="col-12 sm-mb-30">
                                <span>{{ trans('main_trans.text2') }} </span>
                            </div>
                        </div>
                        <div class="row"> 
                            <div class="col-12 sm-mb-30">
                                <span>{{ trans('main_trans.text3') }} </span>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12 sm-mb-30">
                                <span>{{ trans('main_trans.text4') }} </span>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12 sm-mb-30">
                                <span>{{ trans('main_trans.text5') }} </span>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12 sm-mb-30">
                                <span>{{ trans('main_trans.text6') }} </span>
                            </div>
                        </div>
                        
                        
                        <div class="row"> 
                            <div class="col-12 sm-mb-30">
                                <strong>{{ trans('Certificat_trans.text1') }} :</strong>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12 sm-mb-30">
                                <span>{{ trans('Certificat_trans.personal_image') }} </span>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12 sm-mb-30">
                                <span>{{ trans('Certificat_trans.bank') }}</span>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12 sm-mb-30">
                                <span>{{ trans('Certificat_trans.ssn') }}</span>
                            </div>
                        </div>

                       
                        <div class="row">
                            <div class="col-12 sm-mb-30">
                                <strong>{{ trans('Certificat_trans.text4') }} :</strong>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-12 sm-mb-30">
                                <span class="text-danger">{{ trans('Certificat_trans.text5') }} </span>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12 sm-mb-30">
                                <span class="text-danger">{{ trans('Certificat_trans.text7') }}</span>
                            </div>
                        </div>
                        

                    </div> --}}
                    {{-- New --}}
                    <div class="col-lg-6">
                        <div>
                            <span class="text-success">{{ trans('main_trans.info') }}</span>
                        </div>
                        <div class="accordion gray plus-icon round">
                            <div class="acd-group acd-active">
                              <a href="#" class="acd-heading">{{ trans('main_trans.text1') }} :</a>
                              <div class="acd-des" style="">
                                <span>{{ trans('Certificat_trans.text7') }} </span><br>
                                <span>{{ trans('main_trans.text2') }} </span><br>
                                <span>{{ trans('main_trans.text3') }} </span><br>
                                <span>{{ trans('main_trans.text4') }} </span><br>
                                <span>{{ trans('main_trans.text5') }} </span><br>
                                <span>{{ trans('main_trans.text6') }} </span><br>
                                
                               </div>
                            </div>
                            <div class="acd-group">
                              <a href="#" class="acd-heading">{{ trans('Certificat_trans.text1') }} :</a>
                              <div class="acd-des" style="display: none;"> 
                                <span>{{ trans('Certificat_trans.personal_image') }} </span><br>
                                <span>{{ trans('Certificat_trans.bank') }}</span><br>
                                  <span>{{ trans('Certificat_trans.ssn') }}</span><br>
                            </div>
                            </div>
                            <div class="acd-group">
                              <a href="#" class="acd-heading">{{ trans('Certificat_trans.text4') }} :</a>
                              <div class="acd-des" style="display: none;">
                                {{ trans('Certificat_trans.text5') }} <br>
                                {{ trans('Certificat_trans.text7') }}
                            </div>
                            </div>
                          </div>
                    </div>
                    @can('isUser')
                    <div class="col-lg-6">
                       
                        
                        <div class="row">
                            <div class="col-12 sm-mb-30">
                                <strong><strong>{{ trans('Certificat_trans.text3') }}</strong></strong>
                            </div>
                        </div>
                        {{-- certificats --}}
                        @if ($certificats->count() > 0) 
                        {{ trans('main_trans.certificat_request') }}
                        <div class="row">
                            <table class="table table-striped table-bordered p-0">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{ trans('Certificat_trans.certificat_type') }}</th>
                                        <th>{{ trans('Statment_trans.Result_process') }}</th>
                                        <th>{{ trans('Statment_trans.Pay_process') }}</th>
                                        <th>{{ trans('Depts_trans.Processes') }}</th>
                                    </tr>
                                </thead>
                                <tboby>
                                    @foreach ($certificats as $index => $certificat)
                                        <tr>
                                            <td>{{ $index + 1 }}</td>
                                            <td>
                                                @if ($certificat->certificat_type == ["1"])
                                                {{ trans('Certificat_trans.Details') }}
                                                @elseif ($certificat->certificat_type == ["2"])
                                                {{ trans('Certificat_trans.Regular') }}
                                                @else
                                                        {{ trans('Certificat_trans.Regular') }} - {{ trans('Certificat_trans.Details') }}
                                                @endif
                                            </td> 
                                            <td>
                                                @if ($certificat->r_status == '0')
                                                    <span class="label text-info">
                                                         {{ trans('Certificat_trans.Process') }}
                                                    </span>
                                                @elseif ($certificat->r_status == '1')
                                                <span class="label text-success">
                                                    {{ trans('Certificat_trans.complate') }}
                                                </span>
                                                @else
                                                    <span class="label text-danger">
                                                        {{ trans('Certificat_trans.reject') }}
                                                    </span>
                                                @endif
                                            </td>
                                            <td>
                                                @if ($certificat->f_status == '0')
                                                    <span class="label text-info">
                                                        {{ trans('Certificat_trans.Process') }}
                                                    </span>
                                                @elseif ($certificat->f_status == '1')
                                                <span class="label text-success">
                                                    {{ trans('Certificat_trans.complate') }}
                                                </span>
                                                @else
                                                    <span class="label text-danger">
                                                        {{ trans('Certificat_trans.reject') }}
                                                    </span>
                                                @endif
                                            </td>
                                            <td>
                                                <a href="{{ route('certificats.show', encrypt($certificat->id)) }}">
                                                    <button  type="button" class="btn btn-success btn-sm" data-toggle="modal"
                                                    
                                                    title="{{ trans('Certificat_trans.show') }}"><i
                                                        class="fa fa-eye"> {{ trans('Statment_trans.show') }} </i></button>
                                            </td>
                                  
                                        </tr>
                                    @endforeach
                                </tboby>
                            </table>
                        </div>
                       
                        @endif
                        {{-- registers --}}
                        @if ($registers->count() > 0)
                        {{ trans('main_trans.Register_request') }}
                        <div class="row">
                            <table class="table table-striped table-bordered p-0">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{ trans('Register_trans.language') }}</th>
                                        <th>{{ trans('Statment_trans.Result_process') }}</th>
                                        <th>{{ trans('Statment_trans.Pay_process') }}</th>
                                        <th>{{ trans('Depts_trans.Processes') }}</th>
                                       
                                    </tr>
                                </thead>
                                <tboby>
                                    @foreach ($registers as $index => $register)
                                        <tr>
                                            <td>{{ $index + 1 }}</td> 
                                            <td>
                                                @if ($register->lang == '1')
                                                        
                                                         {{ trans('Register_trans.Arabic') }}
                                                @else
                                                {{ trans('Register_trans.English') }}
                                                @endif
                                            </td>
                                           
                                            <td>
                                                @if ($register->r_status == '0')
                                                    <span class="label text-info">
                                                         {{ trans('Statment_trans.processing') }}
                                                    </span>
                                                @elseif ($register->r_status == '1')
                                                <span class="label text-success">
                                                    {{ trans('Statment_trans.complate') }}
                                                </span>
                                                @else
                                                <span class="label text-danger">
                                                    {{ trans('Statment_trans.reject') }}
                                                </span>
                                                @endif
                                            </td>
                                            <td>
                                                @if ($register->f_status == '0')
                                                    <span class="label text-info">
                                                         {{ trans('Statment_trans.processing') }}
                                                    </span>
                                                @elseif ($register->f_status == '1')
                                                <span class="label text-success">
                                                    {{ trans('Statment_trans.complate') }}
                                                </span>
                                                @else
                                                <span class="label text-danger">
                                                    {{ trans('Statment_trans.reject') }}
                                                </span>
                                                @endif
                                            </td>
                                            <td>
                                                <a href="{{ route('registers.show', encrypt($register->id)) }}">
                                                    <button  type="button" class="btn btn-success btn-sm" data-toggle="modal"
                                                    title="{{ trans('Statment_trans.show') }}"><i
                                                        class="fa fa-eye"> {{ trans('Statment_trans.show') }} </i></button>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tboby>
                            </table>
                        </div>
                        @endif
                        {{-- records --}}
                        @if ($records->count() > 0)
                        {{ trans('Record_trans.record') }}
                        <div class="row">
                            <table class="table table-striped table-bordered p-0">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{ trans('Register_trans.language') }}</th>
                                        <th>{{ trans('Statment_trans.Result_process') }}</th>
                                        <th>{{ trans('Statment_trans.Pay_process') }}</th>
                                        <th>{{ trans('Depts_trans.Processes') }}</th>
                                    </tr>
                                </thead>
                                <tboby>
                                    @foreach ($records as $index => $record)
                                        <tr>
                                            <td>{{ $index + 1 }}</td> 
                                            <td>
                                                @if ($record->lang == '1')
                                                        
                                                         {{ trans('Register_trans.Arabic') }}
                                                @else
                                                {{ trans('Register_trans.English') }}
                                                @endif
                                            </td>
                                           
                                            <td>
                                                @if ($record->r_status == '0')
                                                    <span class="label text-info">
                                                         {{ trans('Statment_trans.processing') }}
                                                    </span>
                                                @elseif ($record->r_status == '1')
                                                <span class="label text-success">
                                                    {{ trans('Statment_trans.complate') }}
                                                </span>
                                                @else
                                                <span class="label text-danger">
                                                    {{ trans('Statment_trans.reject') }}
                                                </span>
                                                @endif
                                            </td>
                                            <td>
                                                @if ($record->f_status == '0')
                                                    <span class="label text-info">
                                                         {{ trans('Statment_trans.processing') }}
                                                    </span>
                                                @elseif ($record->f_status == '1')
                                                <span class="label text-success">
                                                    {{ trans('Statment_trans.complate') }}
                                                </span>
                                                @else
                                                <span class="label text-danger">
                                                    {{ trans('Statment_trans.reject') }}
                                                </span>
                                                @endif
                                            </td>
                                            <td>
                                                <a href="{{ route('records.show', encrypt($record->id)) }}">
                                                    <button  type="button" class="btn btn-success btn-sm" data-toggle="modal"
                                                    title="{{ trans('Statment_trans.show') }}"><i
                                                        class="fa fa-eye"> {{ trans('Statment_trans.show') }} </i></button>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tboby>
                            </table>
                        </div>
                        @endif
                        {{-- statments --}}
                        @if ($statments->count() > 0)
                        {{ trans('Record_trans.statment') }}
                        <div class="row">
                            <table class="table table-striped table-bordered p-0">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{ trans('Statment_trans.Result_process') }}</th>
                                        <th>{{ trans('Statment_trans.Pay_process') }}</th>
                                        <th>{{ trans('Depts_trans.Processes') }}</th>
                                    </tr>
                                </thead>
                                <tboby>
                                    @foreach ($statments as $index => $statment)
                                        <tr>
                                            <td>{{ $index + 1 }}</td> 
                                            
                                            <td>
                                                @if ($statment->r_status == '0')
                                                    <span class="label text-info">
                                                         {{ trans('Statment_trans.processing') }}
                                                    </span>
                                                @elseif ($statment->r_status == '1')
                                                <span class="label text-success">
                                                    {{ trans('Statment_trans.complate') }}
                                                </span>
                                                @else
                                                <span class="label text-danger">
                                                    {{ trans('Statment_trans.reject') }}
                                                </span>
                                                @endif
                                            </td>
                                            <td>
                                                @if ($statment->f_status == '0')
                                                    <span class="label text-info">
                                                         {{ trans('Statment_trans.processing') }}
                                                    </span>
                                                @elseif ($statment->f_status == '1')
                                                <span class="label text-success">
                                                    {{ trans('Statment_trans.complate') }}
                                                </span>
                                                @else
                                                <span class="label text-danger">
                                                    {{ trans('Statment_trans.reject') }}
                                                </span>
                                                @endif
                                            </td>
                                            <td>
                                                <a href="{{ route('statments.show', encrypt($statment->id)) }}">
                                                    <button  type="button" class="btn btn-success btn-sm" data-toggle="modal"
                                                    title="{{ trans('Statment_trans.show') }}"><i
                                                        class="fa fa-eye"></i> {{ trans('Statment_trans.show') }} </button>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tboby>
                            </table>
                        </div>
                        @endif
                        
                         {{-- deliveries --}}
                        @if ($deliveries->count() > 0)
                        {{ trans('Delivery_trans.request_deliveries') }}
                        <div class="row">
                            <table class="table table-striped table-bordered p-0">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                         <th>{{ trans('Delivery_trans.deliver_name') }}</th>
                                        <th>{{ trans('Delivery_trans.request_date') }}</th>
                                        <th>{{ trans('Delivery_trans.stauts') }}</th>
                                        <th>{{ trans('Depts_trans.Processes') }}</th>
                                    </tr>
                                </thead>
                                <tboby>
                                    @foreach ($deliveries as $index => $delivery)
                                        <tr>
                                            <td>{{ $index + 1 }}</td> 
                                             <td>{{ $delivery->first_name }} {{ $delivery->second_name }} {{ $delivery->midell_name }} {{ $delivery->last_name }}</td>
                                            <td>{{ date('d-m-Y', strtotime($delivery->created_at)) }}</td>
                                            <td>
                                                @if ($delivery->stutus == 0)
                                                    <span class="label text-info">
                                                         {{ trans('Statment_trans.processing') }}
                                                    </span>
                                                @elseif ($delivery->stutus == 1)
                                                <span class="label text-success">
                                                    {{ trans('Statment_trans.complate') }}
                                                </span>
                                                @else
                                                <span class="label text-danger">
                                                    {{ trans('Statment_trans.reject') }}
                                                </span>
                                                @endif
                                            </td>
                                           
                                            <td>
                                                <a href="{{ route('deliveries.show', encrypt($delivery->id)) }}">
                                                    <button  type="button" class="btn btn-success btn-sm" data-toggle="modal"
                                                    title="{{ trans('Statment_trans.show') }}"><i
                                                        class="fa fa-eye"></i> {{ trans('Statment_trans.show') }} </button>
                                                 @can('isUser') 
                                       <a href="{{ route('deliveries.edit', encrypt($delivery->id)) }}">
                                        <button  type="button" class="btn btn-info btn-sm" data-toggle="modal"
                                        
                                        title="{{ trans('Statment_trans.Edit') }}"><i
                                            class="fa fa-edit"> {{ trans('Statment_trans.Edit') }}</i></button>
                                       </a>
                                       @endcan
                                       
                                            </td>
                                        </tr>
                                    @endforeach
                                </tboby>
                            </table>
                        </div>
                        @endif
                        
                         {{-- Document --}}
                        @if ($documents->count() > 0)
                        {{ trans('Document_trans.create') }}
                        <div class="row">
                            <table class="table table-striped table-bordered p-0">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{ trans('Certificat_trans.date') }}</th>
                                        <th>{{ trans('Document_trans.documents_prosess') }}</th>
                                        <th>{{ trans('Certificat_trans.bank_note') }}</th>
                                        <th>{{ trans('Depts_trans.Processes') }}</th>
                                    </tr>
                                </thead>
                                <tboby>
                                    @foreach ($documents as $index => $document)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                      
                                        <td>{{ date('d-m-y', strtotime($document->created_at)) }}</td>
                                       
                                        <td>
                                            @if ($document->stutus == '0')
                                                <span class="label text-info">
                                                     {{ trans('Certificat_trans.Process') }}
                                                </span>
                                            @elseif ($document->stutus == '1')
                                            <span class="label text-success">
                                                {{ trans('Certificat_trans.complate') }}
                                            </span>
                                            @else
                                                <span class="label text-danger">
                                                    {{ trans('Certificat_trans.reject') }}
                                                </span>
                                            @endif
                                        </td>
                                        <td>
                                            @if ($document->f_status == '0')
                                                <span class="label text-info">
                                                     {{ trans('Certificat_trans.Process') }}
                                                </span>
                                            @elseif ($document->f_status == '1')
                                            <span class="label text-success">
                                                {{ trans('Certificat_trans.complate') }}
                                            </span>
                                            @else
                                                <span class="label text-danger">
                                                    {{ trans('Certificat_trans.reject') }}
                                                </span>
                                            @endif
                                        </td>
                                       
                                        <td>
                                          
                                           <a href="{{ route('documents.show', encrypt($document->id)) }}">
                                            <button  type="button" class="btn btn-success btn-sm" data-toggle="modal"
                                            
                                            title="{{ trans('Certificat_trans.show') }}"><i
                                                class="fa fa-eye"> {{ trans('Statment_trans.show') }}</i></button>
                                           </a>
                                          
                                        </td>
                                    </tr>
                                    @endforeach
                                </tboby>
                            </table>
                        </div>
                        @endif
                        
                        {{-- Refunds --}}
                         @if ($refunds->count() > 0)
                         {{ trans('Document_trans.create') }}
                         <div class="row">
                             <table class="table table-striped table-bordered p-0">
                                 <thead>
                                     <tr>
                                        <th> {{ trans('Refund_trans.doc') }} </th>
                                        <th>{{ trans('Delivery_trans.request_date') }}</th>
                                        <th>{{ trans('Delivery_trans.stauts') }}</th>
                                        <th>{{ trans('Depts_trans.Processes') }}</th>
                                     </tr>
                                 </thead>
                                 <tboby>
                                     @foreach ($refunds as $index => $refund)
                                     <tr>
                                        <td>
                                            @if ($refund->type == '1')
                                                <span class="label text-info">
                                                    {{ trans('Refund_trans.Certificat') }}
                                                </span>
                                            @elseif ($refund->type == '2')
                                            <span class="label text-info">
                                                {{ trans('Refund_trans.Statment') }}
                                            </span>
                                            @elseif ($refund->type == '3')
                                            <span class="label text-info">
                                                {{ trans('Refund_trans.Record') }}
                                            </span>
                                            @else
                                            <span class="label text-info">
                                                {{ trans('Refund_trans.Register') }} 
                                            </span>
                                            @endif
                                        </td>
                                        <td>{{ $refund->created_at}}</td>
                                        <td>
                                            @if ($refund->stutus == '0')
                                                <span class="label text-info">
                                                     {{ trans('Statment_trans.processing') }}
                                                </span>
                                            @elseif ($refund->stutus == '1')
                                            <span class="label text-success">
                                                {{ trans('Statment_trans.complate') }}
                                            </span>
                                            @else
                                            <span class="label text-danger">
                                                {{ trans('Statment_trans.reject') }}
                                            </span>
                                            @endif
                                        </td>
                                        <td>
                                           @can('isAdmin') 
                                           <a href="{{ route('deliveries.edit', encrypt($refund->id)) }}">
                                            <button  type="button" class="btn btn-info btn-sm" data-toggle="modal"
                                            title="{{ trans('Statment_trans.Edit') }}"><i
                                                class="fa fa-edit"></i></button>
                                           </a>
                                           @endcan
                                           <a href="{{ route('refunds.show', encrypt($refund->id)) }}">
                                            <button  type="button" class="btn btn-success btn-sm" data-toggle="modal"
                                            
                                            title="{{ trans('Statment_trans.show') }}"><i
                                                class="fa fa-eye"></i></button>
                                           </a>
                                        </td>
                                     </tr>
                                     @endforeach
                                 </tboby>
                             </table>
                         </div>
                         @endif
                         
                    </div>
                    @endcan
                </div>
            </div>
            <br> <br> <br> <br> <br> <br> <br> <br> <br>
            <!--=================================
 wrapper -->

            <!--=================================
 footer -->

            @include('layouts.footer')
        </div><!-- main content wrapper end-->
    </div>
    </div>
    </div>

    <!--=================================
 footer -->

    @include('layouts.footer-scripts')

</body>

</html>
