@extends('layouts.master')
@section('css')
    @toastr_css
    <link href="{{ URL::asset('assets/plugins/fileuploads/css/fileupload.css') }}" rel="stylesheet" type="text/css" />
    <!---Internal Fancy uploader css-->
    <link href="{{ URL::asset('assets/plugins/fancyuploder/fancy_fileupload.css') }}" rel="stylesheet" />
@section('title')
{{ trans('Delivery_trans.title_page') }}
@stop
@endsection
@section('page-header')
    <!-- breadcrumb -->
@section('PageTitle')
{{ trans('Delivery_trans.title_page') }} 
@stop
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> {{ trans('Delivery_trans.title_page') }}</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a></li>
                <li class="breadcrumb-item active"> {{ trans('Delivery_trans.title_page') }}</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
    <!-- row -->
    <div class="row">
        <div class="col-md-12 mb-30">
            <div class="card card-statistics h-100">
                <div class="card-body">

                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    {{-- <a href="{{ route('statments.index') }}">
                        <button type="button" class="btn btn-primary l-t-20">
                            {{ trans('main_trans.back') }}
                        </button>
                    </a><br><br> --}}
                    @if ($certificats->count() > 0 || $record->count() > 0 || $register->count() > 0 || $statment->count() > 0 ) 
                      <strong>{{ trans('Delivery_trans.request_deliveries') }}</strong><br>
                      <div class="row">
                        <div class="col-md-12">
                            <span class="text-danger">{{ trans('Delivery_trans.agreement') }}</span>
                        </div>
                      </div><br>
                      <div class="row">
                        <div class="col-md-3">
                            {{ trans('Delivery_trans.studen_name') }} : {{ Auth::user()->first_name }}
                        </div>
                        <div class="col-md-3">
                            <fieldset>
                                <input type="checkbox" id="agree" name="agree"/>
                                <label>موافق</label>
                            </fieldset>
                        </div>
                      </div><br>
                      
                         {!! Form::open(['route' => 'deliveries.store', 'autocomplete' => 'off', 'files' => 'ture' ]) !!}   
                            @csrf
                            
                            <div class="row" id="docType">
                                <div class="col-md-3">
                                    <label>{{ trans('Delivery_trans.doc_type') }} : <span class="text-danger">*</span></label>
                                    <select name="docType" class="custom-select" <select class="custom-select"
                                        aria-label="Default select example">
                                        <option selected disabled>{{ trans('main_trans.Choose') }}</option>
                                        <option value='1'>{{trans('Delivery_trans.certificat')}}</option>
                                        <option value='2'>{{trans('Delivery_trans.statment')}}</option>
                                        <option value='3'>{{trans('Delivery_trans.record')}}</option>
                                        <option value='4'>{{trans('Delivery_trans.register')}}</option>
                                    </select>
                                </div>
                            </div><br>
                            <strong id="info"> {{ trans('Delivery_trans.Requester') }}</strong>
                            <div class="row" id="First_name">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>{{ trans('Delivery_trans.First_name') }} : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="first_name" type="text" value="{{ old('first_name') }}">
                                </div>
                             </div>
                                <div class="col-md-3" id="Second_name">
                                    <div class="form-group">
                                        <label>{{ trans('Delivery_trans.Second_name') }} : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="second_name" type="text" value="{{ old('second_name') }}">
                                    </div>
                                </div> 
                                <div class="col-md-3">
                                    <div class="form-group" id="Third_name">
                                        <label>{{ trans('Delivery_trans.Third_name') }} : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="midell_name" type="text" value="{{ old('midell_name') }}">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group" id="Last_name">
                                        <label>{{ trans('Delivery_trans.Last_name') }} : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="last_name" type="text" value="{{ old('last_name') }}">
                                    </div>
                                </div>
                            </div>

                            <div class="row" id="ssn">
                               
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="ssn">{{trans('Delivery_trans.ssn')}} : <span class="text-danger">*</span></label>
                                        <input type="file" name="ssn" class="dropify"
                                        accept="image/*" data-height="70" />
                                    </div>
                                </div> 
                            </div>
                            <br>
                            <div class="d-flex justify-content-center" id="submit1">
                                <button type="submit" class="btn btn-primary btn-lg">{{trans('Delivery_trans.submit')}}</button>
                            </div>
                            
                            {!! Form::close() !!}
                     <br><br><br>
                     @else
                        
                        <h2>{{trans('Delivery_trans.verfy')}}</h2>
                        
                    @endif
                </div>
                
            </div>
        </div>
    </div>
    <!-- row closed -->
@endsection
@section('js')
    @toastr_js
    @toastr_render
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/file-upload.js') }}"></script>
    <!--Internal Fancy uploader js-->
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.ui.widget.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.iframe-transport.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fancy-fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/fancy-uploader.js') }}"></script>
   
   <script>
        $(document).ready(function() {
             $('#info').hide();
            $('#docType').hide();
            $('#First_name').hide();
            $('#Second_name').hide();
            $('#Third_name').hide();
            $('#Last_name').hide();
            $('#ssn').hide();
            $('#submit1').hide();
                 
            $('input[type="checkbox"]').click(function() {
                if ($(this).attr('id') == 'agree') {
                     $('#info').show();
                    $('#docType').show();
                    $('#First_name').show();
                    $('#Second_name').show();
                    $('#Third_name').show();
                    $('#Last_name').show();
                    $('#ssn').show();
                    $('#submit1').show();
                } 
               
            });
        });
    
    </script>

    @endsection
