@extends('layouts.master')
@section('css')
    @toastr_css
@section('title')
{{ trans('Document_trans.deleted_document') }}
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> {{ trans('Document_trans.deleted_document') }}</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a></li>
                <li class="breadcrumb-item active"> {{ trans('Document_trans.deleted_document') }}</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">

    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            <div class="card-body">

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
               
                <div class="table-responsive">
                    <table id="datatable" class="table table-striped table-bordered p-0">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>{{ trans('Certificat_trans.name') }}</th>
                                <th>{{ trans('Depts_trans.Name_Dept') }}</th>
                                <th>{{ trans('Certificat_trans.date') }}</th>
                                <th>{{ trans('Certificat_trans.certificat_type') }}</th>
                                <!--<th>{{ trans('Document_trans.document_type') }}</th>-->
                                <th>{{ trans('Document_trans.documents_prosess') }}</th>
                                <th>{{ trans('Certificat_trans.bank_note') }}</th>
                                <th>{{ trans('Depts_trans.Processes') }}</th>
                            </tr>
                        </thead>
                        <tboby>
                            @foreach ($documents as $index => $document)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    {{-- <td>{{ $certificat->first_name }} {{ $certificat->second_name }} {{ $certificat->midell_name }} {{ $certificat->last_name }}</td>
                                     --}}
                                    <td>{{ $document->user->first_name }}</td>
                                    <td>{{ $document->user->dept->name }}</td>
                                    <td>{{ date('d-m-y', strtotime($document->created_at)) }}</td>
                                    <td>
                                        @if ($document->certificat->certificat_type == ["1"])
                                        {{ trans('Certificat_trans.Details') }}
                                        @elseif ($document->certificat->certificat_type == ["2"])
                                        {{ trans('Certificat_trans.Regular') }}
                                        @else
                                          {{ trans('Certificat_trans.Regular') }} - {{ trans('Certificat_trans.Details') }}
                                        @endif
                                    </td>
                                    <!--<td>-->
                                    <!--    @if ($document->type == ["1","2","3","4"])-->
                                    <!--    {{ trans('Document_trans.type1') }} - {{ trans('Document_trans.type2') }}-->
                                    <!--    -{{ trans('Document_trans.type3') }} - {{ trans('Document_trans.type4') }}-->
                                       
                                    <!--    @elseif ($document->type == ["1"])-->
                                    <!--    {{ trans('Document_trans.type1') }}-->
                                    <!--    @elseif ($document->type == ["2"])-->
                                    <!--    {{ trans('Document_trans.type2') }}-->
                                    <!--    @elseif ($document->type == ["3"])-->
                                    <!--    {{ trans('Document_trans.type3') }}-->
                                    <!--    @elseif ($document->type == ["4"])-->
                                    <!--    {{ trans('Document_trans.type4') }}-->

                                    <!--    @elseif ($document->type == ["1","2"])-->
                                    <!--    {{ trans('Document_trans.type1') }} - {{ trans('Document_trans.type2') }}-->
                                    <!--    @elseif ($document->type == ["3","4"])-->
                                    <!--    {{ trans('Document_trans.type3') }} - {{ trans('Document_trans.type4') }}-->


                                    <!--    @elseif ($document->type == ["1","3"])-->
                                    <!--    {{ trans('Document_trans.type1') }} - {{ trans('Document_trans.type3') }}-->
                                    <!--    @elseif ($document->type == ["2","4"])-->
                                    <!--    {{ trans('Document_trans.type2') }} - {{ trans('Document_trans.type4') }}-->
                                      
                                    <!--    @else-->
                                    <!--    {{ trans('Document_trans.error_index') }}-->
                                    <!--    @endif-->
                                    <!--</td>-->
                                    <td>
                                        @if ($document->stutus == '0')
                                            <span class="label text-info">
                                                 {{ trans('Certificat_trans.Process') }}
                                            </span>
                                        @elseif ($document->stutus == '1')
                                        <span class="label text-success">
                                            {{ trans('Certificat_trans.complate') }}
                                        </span>
                                        @else
                                            <span class="label text-danger">
                                                {{ trans('Certificat_trans.reject') }}
                                            </span>
                                        @endif
                                    </td>
                                    <td>
                                        @if ($document->f_status == '0')
                                            <span class="label text-info">
                                                 {{ trans('Certificat_trans.Process') }}
                                            </span>
                                        @elseif ($document->f_status == '1')
                                        <span class="label text-success">
                                            {{ trans('Certificat_trans.complate') }}
                                        </span>
                                        @else
                                            <span class="label text-danger">
                                                {{ trans('Certificat_trans.reject') }}
                                            </span>
                                        @endif
                                    </td>
                                   
                                    <td>
                                       @can('حذف شهادة')
                                       <button class="btn btn-success btn-sm" data-toggle="modal"
                                       data-target="#delete"
                                       data-id="{{ $document->id }}"
                                       title="  {{ trans('Certificat_trans.restor') }}"><i
                                           class="fa fa-trash">  {{ trans('Certificat_trans.restor') }}</i></button>
                                                @endcan
                                    </td>
                                </tr>


    <!-- delete_modal_Subject -->
                                <div class="modal fade" id="delete" tabindex="-1" role="dialog"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 style="font-family: 'Cairo', sans-serif;" class="modal-title"
                                                    id="exampleModalLabel">
                                                    {{ trans('Certificat_trans.delete_certificat') }}
                                                </h5> 
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                {!! Form::open(['url' => ['RestoerDocument'], 'method' => 'GET']) !!}
                                                {{-- {{ method_field('POST') }} --}}
                                                @csrf
                                                {{ trans('Certificat_trans.restor_confirm') }}
                                                <input id="id" type="hidden" name="id" class="form-control">
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-dismiss="modal">{{ trans('Certificat_trans.Close') }}</button>
                                                    <button type="submit"
                                                        class="btn btn-success">{{ trans('Certificat_trans.restor') }}</button>
                                                </div>
                                                {!! Form::close() !!}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach


                        </tboby>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- add_modal_Subject 
   
-->

</div>
<!-- row closed -->
@endsection
@section('js')
<script>
    $('#delete').on('show.bs.modal', function(event) {
        var button = $(event.relatedTarget)
        var id = button.data('id')
        var modal = $(this)
        modal.find('.modal-body #id').val(id);
       
    })

</script>

@toastr_js
@toastr_render
@endsection
