@extends('layouts.master')
@section('css')
    @toastr_css
    <link href="{{ URL::asset('assets/plugins/fileuploads/css/fileupload.css') }}" rel="stylesheet" type="text/css" />
    <!---Internal Fancy uploader css-->
    <link href="{{ URL::asset('assets/plugins/fancyuploder/fancy_fileupload.css') }}" rel="stylesheet" />
@section('title')
{{ trans('Document_trans.title_page') }}
@stop
@endsection
@section('page-header')
    <!-- breadcrumb -->
@section('PageTitle')
{{ trans('Document_trans.title_page') }} 
@stop
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> {{ trans('Document_trans.title_page') }}</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a></li>
                <li class="breadcrumb-item active"> {{ trans('Document_trans.title_page') }}</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
    <!-- row -->
    <div class="row">
        <div class="col-md-12 mb-30">
            <div class="card card-statistics h-100">
                <div class="card-body">

                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif 
                    @if (isset($certificatcomplate))
                    {{-- @if ($certificatcomplate->count() > 0)  --}}
                    
                        {{-- <form method="post"  action="{{ route('certificats.store') }}" autocomplete="off" files="ture"> --}}
                         {!! Form::open(['route' => 'documents.store', 'autocomplete' => 'off', 'files' => 'ture' ]) !!}   
                            @csrf
                            {{-- <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{ trans('Depts_trans.Name_Dept') }} : <span class="text-danger">*</span></label>
                                        <select name="dept_id" class="custom-select" <select class="custom-select"
                                            aria-label="Default select example">
                                            <option selected disabled>{{ trans('main_trans.Choose') }}</option>
                                            @foreach ($depts as $dept)
                                                <option value='{{ $dept->id }}'> {{ $dept->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{ trans('Certificat_trans.certificat_type') }} : <span class="text-danger">*</span></label>
                                        <select name="certificat_type" id="select-beast" class="custom-select">
                                            <option value="" selected disabled>{{ trans('main_trans.Choose') }} </option>
                                            <option value="2">{{ trans('Certificat_trans.Regular') }}</option>
                                            <option value="1">{{ trans('Certificat_trans.Details') }}</option>
                                        </select>
                                    </div>
                                </div>
                            </div> --}}
                            <div class="col-md-12">
                                <div class="form-group">
                                    <span class="text-danger">{{ trans('Certificat_trans.text7') }} </span><br>
                                    <span class="text-danger">{{ trans('Document_trans.info3') }}</span><br>
                                    <span class="text-danger">{{ trans('Document_trans.info4') }}</span><br>
                                    <span class="text-danger">{{ trans('Document_trans.info5') }}</span>
                                </div>
                              
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                <strong>{{ trans('Document_trans.info1') }}</strong>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">

                                    @if ($certificatcomplate->certificat_type == ["1"])
                                    {{ trans('Certificat_trans.Details') }}
                                    
                                    @elseif ($certificatcomplate->certificat_type == ["2"])
                                    {{ trans('Certificat_trans.Regular') }}
                                    
                                    @else
                                       {{ trans('Certificat_trans.Regular') }} &nbsp  &nbsp  &nbsp  &nbsp  &nbsp &nbsp  &nbsp  &nbsp  &nbsp &nbsp &nbsp {{ trans('Certificat_trans.Details') }}
                                   
                                    @endif

                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                <strong>{{ trans('Document_trans.info2') }}</strong>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <fieldset>
                                        <input type="checkbox" name="type[]" value='1' />
                                        <label> {{ trans('Document_trans.type1') }} </label>
                                    </fieldset> 
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <fieldset>
                                        <input type="checkbox" name="type[]" value='2' />
                                        <label> {{ trans('Document_trans.type2') }}</label>
                                    </fieldset>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                <fieldset>
                                    <input type="checkbox" name="type[]" value='3' />
                                    <label>{{ trans('Document_trans.type3') }} </label>
                                </fieldset> 
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <fieldset>
                                        <input type="checkbox" name="type[]" value='4' />
                                        <label> {{ trans('Document_trans.type4') }} </label>
                                    </fieldset>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="bank">{{trans('Certificat_trans.amount')}} : <span class="text-danger">*</span></label>
                                    <select name="amount" class="custom-select" <select class="custom-select"
                                        aria-label="Default select example">
                                        <option selected disabled>{{ trans('main_trans.Choose') }}</option>
                                            <option value='20.000'>20.000</option>
                                            <option value='35.000'>35.000</option>
                                            <option value='50.000'> 50.000</option>
                                            <option value='65.000'> 65.000</option>
                                    </select>
                                </div>
                            </div>
                            <p class="text-danger">* صيغة المرفقات: jpeg ,jpg , png </p>
                             <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="bank">{{trans('Certificat_trans.bank')}} : <span class="text-danger">*</span></label>
                                        <input type="file" name="bank" class="dropify"
                                        accept="image/*" data-height="90" />
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="notification_number">{{trans('Certificat_trans.notification_number')}} : <span class="text-danger">*</span></label>
                                        <input  class="form-control"  name="notification_number" type="number" value="{{ old('notification_number') }}">
                                    </div>
                                </div>
                               
                            </div>

                             
                            <div class="d-flex justify-content-center">
                                <button type="submit" class="btn btn-primary btn-lg">{{trans('Certificat_trans.submit')}}</button>
                            </div>
                            
                            {!! Form::close() !!}
                            @else
                        
                            <h2>{{trans('Document_trans.verfy')}}</h2>
                            
                            @endif
                </div>
            </div>
        </div>
    </div>
    <!-- row closed -->
@endsection
@section('js')
    @toastr_js
    @toastr_render
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/file-upload.js') }}"></script>
    <!--Internal Fancy uploader js-->
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.ui.widget.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.iframe-transport.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fancy-fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/fancy-uploader.js') }}"></script>
@endsection
