@extends('layouts.master')
@section('css')
    @toastr_css
    <link href="{{ URL::asset('assets/plugins/fileuploads/css/fileupload.css') }}" rel="stylesheet" type="text/css" />
    <!---Internal Fancy uploader css-->
    <link href="{{ URL::asset('assets/plugins/fancyuploder/fancy_fileupload.css') }}" rel="stylesheet" />
@section('title')
{{ trans('Graduate_trans.title_page') }}
@stop
@endsection
@section('page-header')
    <!-- breadcrumb -->
@section('PageTitle')
سند قبض 
@stop
<!-- breadcrumb -->
@endsection
@section('content')
    <!-- row -->
    <div class="row">
        <div class="col-md-12 mb-30">
            <div class="card card-statistics h-100">
                <div class="card-body">

                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <a href="{{ route('certificats.index') }}">
                        <button type="button" class="btn btn-primary l-t-20">
                            {{ trans('main_trans.back') }}
                        </button>
                        <br><br> 
                    </a>
                   
                            {!! Form::model($certificat, ['method' => 'PATCH','files' => 'ture','route' => ['certificats.update', $certificat->id]]) !!}
                            @csrf
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{ trans('Depts_trans.Name_Dept') }} : <span class="text-danger">*</span></label>
                                        <select name="dept_id" class="custom-select" <select class="custom-select"
                                            aria-label="Default select example" disabled>
                                            <option selected disabled>{{ trans('main_trans.Choose') }}</option>
                                            @foreach($depts as $dept)
                                            <option value='{{ $dept->id}}'{{$dept->id == $certificat->dept_id ? 'selected' : '' }}> {{ $dept->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{ trans('Graduate_trans.certificat_type') }} : <span class="text-danger">*</span></label>
                                        <select name="certificat_type" id="select-beast" class="form-control custom-select" disabled>
                                            <option value="" selected disabled>{{ trans('main_trans.Choose') }} </option>
                                                <option value='["1"]' {{ $certificat->certificat_type == ["1"] ? 'selected' : '' }}>  {{ trans('Graduate_trans.Details') }} </option>
                                                <option value='["2"]' {{ $certificat->certificat_type == ["2"] ? 'selected' : '' }}> {{ trans('Graduate_trans.Regular') }} </option>
                                                <option value='["2","1"]' {{ $certificat->certificat_type == ["2","1"] ? 'selected' : '' }}> {{ trans('Graduate_trans.Regular') }} - {{ trans('Graduate_trans.Details') }}</option>
                                            </select>
                                        </select>             

                                    </div>
                                </div>

                                {{-- <div class="col-md-4">
                                    <div class="form-group">
                                        <label>{{ trans('Graduate_trans.language') }} : <span class="text-danger">*</span></label>
                                        <select name="lang" class="custom-select" <select class="custom-select"
                                            aria-label="Default select example" disabled>
                                            <option value='11' {{ $certificat->lang == ["11"] ? 'selected' : '' }}>  {{ trans('Graduate_trans.Arabic') }} </option>
                                            <option value='21' {{ $certificat->lang == ["21"] ? 'selected' : '' }}>  {{ trans('Graduate_trans.English') }} </option>
                                            <option value='21' {{ $certificat->lang == ["11","22"] ? 'selected' : '' }}>  {{ trans('Graduate_trans.Arabic') }} - {{ trans('Graduate_trans.English') }} </option>
                                            <option value='21' {{ $certificat->lang == ["11","21","12","22"] ? 'selected' : '' }}>  {{ trans('Graduate_trans.Arabic') }} - {{ trans('Graduate_trans.English') }} </option>
                                        </select>            
                                        
                                    </div>
                                </div> --}}
                            </div>

                            @if (isset($certificat->first_name[0]))
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>{{ trans('Graduate_trans.First_name') }} : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="first_name[]" type="text" value="{{ $certificat->first_name[0] }}">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>{{ trans('Graduate_trans.Second_name') }} : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="second_name[]" type="text" value="{{ $certificat->second_name[0] }}">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>{{ trans('Graduate_trans.Third_name') }} : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="midell_name[]" type="text" value="{{ $certificat->midell_name[0] }}">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>{{ trans('Graduate_trans.Last_name') }} : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="last_name[]" type="text" value="{{ $certificat->last_name[0] }}">
                                    </div>
                                </div>
                            </div>
                            @endif

                            @if (isset($certificat->first_name[1]))
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>First Name : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="first_name[]" type="text" value="{{ $certificat->first_name[1] }}">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Second Name : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="second_name[]" type="text" value="{{ $certificat->second_name[1] }}">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Third Name : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="midell_name[]" type="text" value="{{ $certificat->midell_name[1] }}">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Last Name : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="last_name[]" type="text" value="{{ $certificat->last_name[1] }}">
                                    </div>
                                </div>
                            </div>
                            @endif


                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>{{trans('Graduate_trans.certificat_number')}} : <span class="text-danger">*</span></label>
                                        <select name="certificat_number" class="custom-select" <select class="custom-select"
                                            aria-label="Default select example">
                                            <option selected disabled>{{ trans('main_trans.Choose') }}</option>
                                                <option value='1' {{ $certificat->certificat_number == 1 ? 'selected' : '' }}>  1 </option>
                                                <option value='2' {{ $certificat->certificat_number == 2 ? 'selected' : '' }}> 2 </option>
                                                <option value='3' {{ $certificat->certificat_number == 3 ? 'selected' : '' }}> 3</option>
                                                <option value='4' {{ $certificat->certificat_number == 4 ? 'selected' : '' }}> 4</option>
                                            </select>
                                        </select>   
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>{{trans('Graduate_trans.amount')}} : <span class="text-danger">*</span></label>
                                        
                                        <select name="amount" class="custom-select" <select class="custom-select"
                                        aria-label="Default select example"> 
                                            <option selected disabled>{{ trans('main_trans.Choose') }}</option>
                                                <option value='55.000' {{ $certificat->amount == 55.000 ? 'selected' : '' }}>  55.000 </option>
                                                <option value='105.000' {{ $certificat->amount == 105.000 ? 'selected' : '' }}> 105.000 </option>
                                                <option value='155.000' {{ $certificat->amount == 155.000 ? 'selected' : '' }}> 155.000</option>
                                                <option value='205.000' {{ $certificat->amount == 205.000 ? 'selected' : '' }}> 205.000</option>
                                            </select>
                                        </select>   
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="notification_number">{{trans('Graduate_trans.notification_number')}} : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="notification_number" type="number" value="{{ $certificat->notification_number }}">
                                    </div>
                                </div>

                            </div>


                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{ trans('Graduate_trans.admission_year') }} : <span class="text-danger">*</span></label>
                                        <select name="admission_year" class="custom-select" <select class="custom-select"
                                            aria-label="Default select example">
                                            <option selected disabled>{{ trans('main_trans.Choose') }}</option>
                                            @foreach($years as $year)
                                            <option value='{{ $year->name}}'{{$year->name == $certificat->admission_year ? 'selected' : '' }}> {{ $year->name}}</option>
                                            @endforeach

                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{ trans('Graduate_trans.guraduate_year') }} : <span class="text-danger">*</span></label>
                                        <select name="guraduate_year" class="custom-select" <select class="custom-select"
                                            aria-label="Default select example">
                                            <option selected disabled>{{ trans('main_trans.Choose') }}</option>
                                            @foreach($years as $year)
                                            <option value='{{ $year->name}}'{{$year->name == $certificat->guraduate_year ? 'selected' : '' }}> {{ $year->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="personal_image">{{trans('Graduate_trans.personal_image')}} : <span class="text-danger">*</span></label>
                                        <input type="file" name="personal_image" class="dropify"
                                        accept="image/*" data-height="70" />
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="bank">{{trans('Graduate_trans.bank')}} : <span class="text-danger">*</span></label>
                                        <input type="file" name="bank" class="dropify"
                                        accept="image/*" data-height="70" />
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="ssn">{{trans('Graduate_trans.ssn')}} : <span class="text-danger">*</span></label>
                                        <input type="file" name="ssn" class="dropify"
                                        accept="image/*" data-height="70" />
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="school_certificat">{{trans('Graduate_trans.school_certificat')}} : <span class="text-danger">*</span></label>
                                        <input type="file" name="school_certificat" class="dropify"
                                        accept="image/*" data-height="70" />
                                    </div>
                                </div>
                            </div>

                            <div class="d-flex justify-content-center">
                                <button type="submit" class="btn btn-primary btn-lg">{{trans('Graduate_trans.Edit')}}</button>
                            </div>
                            
                        </form>

                </div>
            </div>
        </div>
    </div>
    <!-- row closed -->
@endsection
@section('js')
    @toastr_js
    @toastr_render
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/file-upload.js') }}"></script>
    <!--Internal Fancy uploader js-->
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.ui.widget.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.iframe-transport.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fancy-fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/fancy-uploader.js') }}"></script>
@endsection
