@extends('layouts.master')
@section('css')
    @toastr_css
@section('title')
    {{ trans('Users_trans.personal_information') }}
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
@section('PageTitle')
    {{ trans('Users_trans.personal_information') }}
@stop
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">
    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                       <h4> <li>{{ $error }}</li></h4>
                    @endforeach
                </ul>
            </div>
            @endif
            
            <div class="card-body">
                <div class="card-body">
                    <a href="{{ route('graduates.index') }}">
                        <button type="button" class="btn btn-primary l-t-20">
                            {{ trans('main_trans.back') }}
                        </button>
                        <br><br> 
                    </a>
                    <div class="tab nav-border">
                        <ul class="nav nav-tabs" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active show" id="home-02-tab" data-toggle="tab" href="#home-02"
                                    role="tab" aria-controls="home-02"
                                    aria-selected="true">{{ trans('Users_trans.personal_information') }}</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="profile-02-tab" data-toggle="tab" href="#profile-02"
                                    role="tab" aria-controls="profile-02"
                                    aria-selected="false">{{ trans('Users_trans.Attachments') }}</a>
                            </li>
                            @can('النتيجة')
                            <li class="nav-item">
                                <a class="nav-link" id="profile-03-tab" data-toggle="tab" href="#profile-03"
                                    role="tab" aria-controls="profile-03"
                                    aria-selected="false">{{ trans('Statment_trans.Result_process') }}</a>
                            </li>
                            @endcan
                            @can('المالية')
                            <li class="nav-item">
                                <a class="nav-link" id="profile-03-tab" data-toggle="tab" href="#profile-04"
                                    role="tab" aria-controls="profile-03"
                                    aria-selected="false">{{ trans('Statment_trans.Pay_process') }}</a>
                            </li>
                            @endcan
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane fade active show" id="home-02" role="tabpanel"
                                aria-labelledby="home-02-tab">
                                <table class="table table-hover" style="text-align:right">
                                    <tbody>
                                        
                                        <tr>
                                            <td scope="row">{{ trans('Graduate_trans.language') }}</td>
                                            <td>
                                                @if ($graduate->lang ==["11"])
                                                {{ trans('Graduate_trans.Arabic') }}
                                                @elseif ($graduate->lang == ["21"])
                                                {{ trans('Graduate_trans.English') }}
                                                @elseif ($graduate->lang == ["21","21"])
                                                {{ trans('Graduate_trans.English') }}
                                                @elseif ($graduate->lang == ["11","11"])
                                                {{ trans('Graduate_trans.English') }}
                                                @else
                                                {{ trans('Graduate_trans.Arabic') }} - {{ trans('Graduate_trans.English') }}
                                                @endif
                                            </td>
                                        </tr>
                                       
                                        <tr>
                                            <td scope="row">{{ trans('Graduate_trans.certificat_type') }}</td>
                                            <td>
                                                @if ($graduate->certificat_type == ["1"])
                                                {{ trans('Graduate_trans.Details') }}
                                                @elseif ($graduate->certificat_type == ["2"])
                                                {{ trans('Graduate_trans.Regular') }}
                                                @else
                                                        {{ trans('Graduate_trans.Regular') }} - {{ trans('Graduate_trans.Details') }}
                                                @endif
                                            </td>
                                        </tr>
                                       
                                        <tr>
                                            <td scope="row">{{ trans('Graduate_trans.First_name') }}</td>
                                            @if (isset($graduate->first_name[0]))
                                            <td colspan="2">{{ $graduate->first_name[0] }} </td>
                                            @endif
                                            @if (isset($graduate->first_name[1]))
                                            <td colspan="2">{{ $graduate->first_name[1] }} </td>
                                            @endif
                                        </tr>
                                        <tr>
                                            <td scope="row">{{ trans('Graduate_trans.Second_name') }}</td>
                                            @if (isset($graduate->second_name[0]))
                                            <td colspan="2">{{ $graduate->second_name[0] }}</td>
                                            @endif
                                            @if (isset($graduate->second_name[1]))
                                            <td colspan="2">{{ $graduate->second_name[1] }}</td>
                                            @endif
                                        </tr>
                                        <tr>
                                            <td scope="row">{{ trans('Graduate_trans.Third_name') }}</td>
                                            @if (isset($graduate->midell_name[0]))
                                            <td colspan="2">{{ $graduate->midell_name[0] }}</td>
                                            @endif
                                            @if (isset($graduate->midell_name[1]))
                                            <td colspan="2">{{ $graduate->midell_name[1] }}</td>
                                            @endif
                                        </tr>
                                        <tr>
                                            <td scope="row">{{ trans('Graduate_trans.Last_name') }}</td>
                                            @if (isset($graduate->last_name[0]))
                                            <td colspan="2">{{ $graduate->last_name[0] }}</td>
                                            @endif
                                            @if (isset($graduate->last_name[1]))
                                            <td colspan="2">{{ $graduate->last_name[1] }}</td>
                                            @endif
                                        </tr>
                                        <tr>
                                            <td scope="row">{{ trans('Depts_trans.Name_Dept') }}</td>
                                            <td>{{ $graduate->specialty->name }}</td>
                                        </tr>

                                        <tr>
                                            <td scope="row">{{trans('Graduate_trans.certificat_number')}}</td>
                                            <td>{{ $graduate->certificat_number }}</td>
                                        </tr>

                                        <tr>
                                            <td scope="row">{{trans('Graduate_trans.amount')}}</td>
                                            <td>{{ $graduate->amount }}</td>
                                        </tr>

                                        <tr>
                                            <td scope="row">{{trans('Graduate_trans.notification_number')}}</td>
                                            <td>{{ $graduate->notification_number }}</td>
                                        </tr>

                                        <tr>
                                            <td scope="row">{{ trans('Graduate_trans.date') }}</td>
                                            <td>{{ date('d-m-y', strtotime($graduate->created_at)) }}</td>
                                        </tr>
                                       
                                      <tr>
                                        {{-- <th>{{ trans('Graduate_trans.note') }}</th> --}}
                                        <th>{{ trans('Graduate_trans.r_status') }}</th>
                                        <td>
                                            @if ($graduate->r_status == '0')
                                                <span class="label text-info">
                                                     {{ trans('Graduate_trans.Process') }}
                                                </span>
                                            @elseif ($graduate->r_status == '1')
                                            <span class="label text-success">
                                                {{ trans('Graduate_trans.complate') }}
                                            </span>
                                            @else
                                                <span class="label text-danger">
                                                    {{ trans('Graduate_trans.reject') }}
                                                </span>
                                            @endif
                                        </td>
                                      </tr>

                                      <tr>
                                       
                                        @if (isset($graduate->r_note))
                                        <tr>
                                            <th scope="row">{{ trans('Graduate_trans.note') }}</th>
                                            <td> {{ $graduate->r_note }} </td>
                                        </tr>
                                        @endif
                                      </tr>

                                      <tr>
                                        {{-- <th>{{ trans('Graduate_trans.bank_note') }}</th> --}}
                                        <th>{{ trans('Graduate_trans.f_status') }}</th>
                                        <td>
                                            @if ($graduate->f_status == '0')
                                                <span class="label text-info">
                                                     {{ trans('Graduate_trans.Process') }}
                                                </span>
                                            @elseif ($graduate->f_status == '1')
                                            <span class="label text-success">
                                                {{ trans('Graduate_trans.complate') }}
                                            </span>
                                            @else
                                                <span class="label text-danger">
                                                    {{ trans('Graduate_trans.reject') }}
                                                </span>
                                            @endif
                                        </td>
                                      </tr>
                                       
                                      <tr>
                                       
                                        @if (isset($graduate->f_note))
                                        <tr>
                                            <th scope="row">{{ trans('Graduate_trans.bank_note') }}</th>
                                            <td> {{ $graduate->f_note }} </td>
                                        </tr>
                                        @endif
                                      </tr>
                                      @can('isAdmin')
                                      @if (isset($graduate->acdimec_user))
                                      <tr>
                                          <td scope="row">{{ trans('main_trans.acdimec_user') }}</td>
                                          <td>{{ $graduate->acdimec_user }} </td>
                                      </tr>
                                      @endif
                                      @if (isset($graduate->bank_user))
                                      <tr>
                                          <td scope="row">{{ trans('main_trans.bank_user') }}</td>
                                          <td>{{ $graduate->bank_user }} </td>
                                      </tr>
                                      @endif
                                      @endcan
                                     
                                    </tbody>
                                </table>
                            </div>

                            <div class="tab-pane fade" id="profile-02" role="tabpanel" aria-labelledby="profile-02-tab">
                                <div class="card card-statistics">
                                    <div class="card-body">
                                        <table class="table center-aligned-table mb-0 table table-hover"
                                        style="text-align:center">
                                        <thead>
                                            <tr class="table-secondary">

                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    {{ trans('Graduate_trans.personal_image') }}
                                                    <img height="400" width="400"
                                                        src="{{ asset('images/personalImage/' . $graduate->personal_image) }}">
                                                </td>
                                                <td>
                                                    {{ trans('Graduate_trans.bank') }}
                                                    <img height="400" width="400" src="{{ asset('images/bank/' . $graduate->bank) }}">
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    {{ trans('Graduate_trans.ssn') }}
                                                    <img height="400" width="400" src="{{ asset('images/ssn/' . $graduate->ssn) }}">
                                                </td>
                                                <td>
                                                    {{ trans('Graduate_trans.university_certificat') }}
                                                    <img height="400" width="400" src="{{ asset('images/ssn/' . $graduate->university_certificat) }}">
                                                </td>
                                               
                                            </tr>
                                           
                                        </tbody>
                                    </table>
                                    </div>
                                  
                                </div>
                            </div>
                            @can('النتيجة')
                            <div class="tab-pane fade" id="profile-03" role="tabpanel" aria-labelledby="profile-03-tab">
                                <div class="card card-statistics">
                                    <div class="card-body">
                                        {!! Form::open(['url' => 'GraduateProcessResult', 'autocomplete' => 'off' ]) !!}   
                                        @csrf
                                       <input type="hidden" name="id" value="{{$graduate->id}}">
                                       
                                        <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                            <label class="rdiobox"><input name="rdio" value="1"
                                                    type="radio"><span> {{ trans('Graduate_trans.accept') }}
                                                </span></label>
                                        </div>
                                        <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                            <label class="rdiobox"><input name="rdio" value="2"
                                                    type="radio"><span> {{ trans('Graduate_trans.reject') }}
                                                </span></label>
                                        </div>
                                        
                                        <div class="col-lg-6">
                                            <label for="exampleFormControlTextarea1">{{ trans('Graduate_trans.note') }}</label>
                                            <textarea name="note" class="form-control" wire:model="Address_Father" id="exampleFormControlTextarea1" rows="4"></textarea>
                                        </div>

                                       <br>

                                        <div class="parsley-input col-md-3 mg-t-20 mg-md-t-0">
                                            <button
                                                class="btn btn-primary btn-block">{{ trans('Main_trans.save') }}</button>
                                        </div>
                                        </form>

                                        {!! Form::close() !!}
                                    </div>

                                  
                                </div>
                            </div>
                            @endcan
                            @can('المالية')
                            <div class="tab-pane fade" id="profile-04" role="tabpanel" aria-labelledby="profile-03-tab">
                                <div class="card card-statistics">
                                    <div class="card-body">
                                        {!! Form::open(['url' => 'GraduateProcessPay', 'autocomplete' => 'off' ]) !!}   
                                        @csrf
                                       <input type="hidden" name="id" value="{{$graduate->id}}">
                                       
                                        <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                            <label class="rdiobox"><input name="rdio" value="1"
                                                    type="radio"><span> {{ trans('Graduate_trans.accept') }}
                                                </span></label>
                                        </div>
                                        <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                            <label class="rdiobox"><input name="rdio" value="2"
                                                    type="radio"><span> {{ trans('Graduate_trans.reject') }}
                                                </span></label>
                                        </div>
                                        
                                        <div class="col-lg-6">
                                            <label for="exampleFormControlTextarea1">{{ trans('Graduate_trans.bank_note') }}</label>
                                            <textarea name="note" class="form-control" wire:model="Address_Father" id="exampleFormControlTextarea1" rows="4"></textarea>
                                        </div>

                                       <br>

                                        <div class="parsley-input col-md-3 mg-t-20 mg-md-t-0">
                                            <button
                                                class="btn btn-primary btn-block">{{ trans('Main_trans.save') }}</button>
                                        </div>
                                        </form>

                                        {!! Form::close() !!}
                                    </div>

                                 
                                </div>
                            </div>
                            @endcan
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <!-- row closed -->
    @endsection
    @section('js')
        @toastr_js
        @toastr_render
    @endsection
