@extends('layouts.master')
@section('css')
    @toastr_css
@section('title')
    {{ trans('Record_trans.title_page') }}
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> {{ trans('Record_trans.title_page') }} - {{ trans('main_trans.Trashed') }}</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a></li>
                <li class="breadcrumb-item active"> {{ trans('Record_trans.title_page') }} </li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">

    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            <div class="card-body">

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                @can('تصدير') 
                <a class="btn btn-warning"
                href="#">
                       تصدير
               </a>

               <a class="btn btn-info"
               href="{{ route('recordsCount') }}">
                      تقرير
              </a>
              @endcan

            @can('isAdmin') 
           <a href="{{ route('records.create') }}">
                <button type="button" class="btn btn-primary l-t-20">
                    {{ trans('Statment_trans.submit') }}
                </button>
                <br><br> 
            </a>
            @endcan
          
                <div class="table-responsive">
                    <table id="datatable" class="table table-striped table-bordered p-0">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>{{ trans('Statment_trans.name') }}</th>
                                <th>{{ trans('Depts_trans.Name_Dept') }}</th>
                                <th>{{ trans('Statment_trans.date') }}</th>
                                
                                @can('isAdmin')
                                <th>{{ trans('Statment_trans.by') }}</th>
                                @endcan
                                <th>{{ trans('Statment_trans.Pay_process') }}</th>
                                <th>{{ trans('Statment_trans.Result_process') }}</th>
                                <th>{{ trans('Depts_trans.Processes') }}</th>
                            </tr>
                        </thead>
                        <tboby>
                            @foreach ($records as $index => $record)
                                <tr>
                                    <td>{{ $record->id }}</td>
                                    <td>{{ $record->first_name }} {{ $record->second_name }} {{ $record->midell_name }} {{ $record->last_name }}</td>
                                    
                                    <td>{{ $record->dept->name }}</td>
                                    <td>{{ date('d-m-y', strtotime($record->created_at)) }}</td>
                                    @can('isAdmin')
                                    <td>{{ $record->user->first_name }} {{ $record->user->second_name }}</td>
                                    @endcan
                                    <td>
                                        @if ($record->f_status == '0')
                                            <span class="label text-info">
                                                 {{ trans('Statment_trans.processing') }}
                                            </span>
                                        @elseif ($record->f_status == '1')
                                        <span class="label text-success">
                                            {{ trans('Statment_trans.complate') }}
                                        </span>
                                        @else
                                        <span class="label text-danger">
                                            {{ trans('Statment_trans.reject') }}
                                        </span>
                                        @endif
                                    </td>
                                    <td>
                                        @if ($record->r_status == '0')
                                            <span class="label text-info">
                                                 {{ trans('Statment_trans.processing') }}
                                            </span>
                                        @elseif ($record->r_status == '1')
                                        <span class="label text-success">
                                            {{ trans('Statment_trans.complate') }}
                                        </span>
                                        @else
                                        <span class="label text-danger">
                                            {{ trans('Statment_trans.reject') }}
                                        </span>
                                        @endif
                                    </td>
                                    <td>
                                       
                                       @can( 'حذف القيد')
                                        <button type="button" class="btn btn-success btn-sm" data-toggle="modal"
                                        data-target="#delete"
                                        data-id="{{ $record->id }}"
                                            title="{{ trans('Certificat_trans.restor') }}"><i
                                                class="fa fa-edit"> {{ trans('Certificat_trans.restor') }}</i></button>
                                                @endcan
                                    </td>
                                </tr>


    <!-- delete_modal_Subject -->
                                <div class="modal fade" id="delete" tabindex="-1" role="dialog"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 style="font-family: 'Cairo', sans-serif;" class="modal-title"
                                                    id="exampleModalLabel">
                                                    {{ trans('Record_trans.delete_record') }}
                                                </h5> 
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                {!! Form::open(['url' => ['RestoRrecord'], 'method' => 'GET']) !!}
                                                {{-- {{ method_field('POST') }} --}}
                                                @csrf
                                                {{ trans('Certificat_trans.restor_confirm') }}
                                                <input id="id" type="hidden" name="id" class="form-control">
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-dismiss="modal">{{ trans('Certificat_trans.Close') }}</button>
                                                    <button type="submit"
                                                        class="btn btn-success">{{ trans('Certificat_trans.restor') }}</button>
                                                </div>
                                                {!! Form::close() !!}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach


                        </tboby>
                    </table>
                </div>
            </div>
        </div>
    </div>


</div>
<!-- row closed -->
@endsection
@section('js')
<script>
    $('#delete').on('show.bs.modal', function(event) {
        var button = $(event.relatedTarget)
        var id = button.data('id')
        var modal = $(this)
        modal.find('.modal-body #id').val(id);
       
    })

</script>
@toastr_js
@toastr_render
@endsection
