@extends('layouts.master')
@section('css')
    @toastr_css
    <link href="{{ URL::asset('assets/plugins/fileuploads/css/fileupload.css') }}" rel="stylesheet" type="text/css" />
    <!---Internal Fancy uploader css-->
    <link href="{{ URL::asset('assets/plugins/fancyuploder/fancy_fileupload.css') }}" rel="stylesheet" />
@section('title')
{{ trans('Delivery_trans.Deliveries_Edit') }}
@stop
@endsection
@section('page-header')
  <!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> {{ trans('Delivery_trans.Deliveries_Edit') }}</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a></li>
                <li class="breadcrumb-item active"> {{ trans('Delivery_trans.Deliveries_Edit') }}</li>
            </ol>
        </div>
    </div>
</div>
 <!-- breadcrumb -->
@endsection
@section('content')
    <!-- row -->
    <div class="row">
        <div class="col-md-12 mb-30">
            <div class="card card-statistics h-100">
                <div class="card-body">

                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <a href="{{ route('deliveries.index') }}">
                        <button type="button" class="btn btn-primary l-t-20">
                            {{ trans('main_trans.back') }}
                        </button>
                        <br><br> 
                    </a>
                   
                            {!! Form::model($delivery, ['method' => 'PATCH','files' => 'ture','route' => ['deliveries.update', $delivery->id]]) !!}
                            @csrf
                           
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>{{ trans('Certificat_trans.First_name') }} : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="first_name" type="text" value="{{ $delivery->first_name }}">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>{{ trans('Certificat_trans.Second_name') }} : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="second_name" type="text" value="{{ $delivery->second_name }}">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>{{ trans('Certificat_trans.Third_name') }} : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="midell_name" type="text" value="{{ $delivery->midell_name }}">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>{{ trans('Certificat_trans.Last_name') }} : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="last_name" type="text" value="{{ $delivery->last_name }}">
                                    </div>
                                </div>
                            </div>

                           
                            <div class="row">
                                
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="ssn">{{trans('Certificat_trans.ssn')}} : <span class="text-danger">*</span></label>
                                        <input type="file" name="ssn" class="dropify"
                                        accept="image/*" data-height="70" />
                                    </div>
                                </div>
                            </div>

                            <div class="d-flex justify-content-center">
                                <button type="submit" class="btn btn-primary btn-lg">{{trans('Certificat_trans.Edit')}}</button>
                            </div>
                            
                        </form>
                        <br><br>
                </div>
            </div>
        </div>
    </div>
    <!-- row closed -->
@endsection
@section('js')
    @toastr_js
    @toastr_render
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/file-upload.js') }}"></script>
    <!--Internal Fancy uploader js-->
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.ui.widget.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.iframe-transport.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fancy-fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/fancy-uploader.js') }}"></script>
@endsection
