@extends('layouts.master')
@section('css')
@toastr_css
<link href="{{ URL::asset('assets/plugins/fileuploads/css/fileupload.css') }}" rel="stylesheet" type="text/css" />
<!---Internal Fancy uploader css-->
<link href="{{ URL::asset('assets/plugins/fancyuploder/fancy_fileupload.css') }}" rel="stylesheet" />
@section('title')
    {{ trans('Refund_trans.Refund_information') }}
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> {{ trans('Refund_trans.Refund_information') }}</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a></li>
                <li class="breadcrumb-item active"> {{ trans('Refund_trans.Refund_information') }}</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">
    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                       <h4> <li>{{ $error }}</li></h4>
                    @endforeach
                </ul>
            </div>
            @endif
            
            <div class="card-body">
                <div class="card-body">
                    @can('استرداد')
                    <a href="{{ route('refunds.index') }}">
                        <button type="button" class="btn btn-primary l-t-20">
                            {{ trans('main_trans.back') }}
                        </button>
                        <br><br>
                    </a>
                    @endcan
                     @can('isUser')
                    <a href="{{ url('/dashboard') }}">
                        <button type="button" class="btn btn-primary l-t-20">
                            {{ trans('main_trans.back') }}
                        </button>
                        <br><br>
                    </a>
                    @endcan
                    <div class="tab nav-border">
                        <ul class="nav nav-tabs" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active show" id="home-02-tab" data-toggle="tab" href="#home-02"
                                    role="tab" aria-controls="home-02"
                                    aria-selected="true">{{ trans('Refund_trans.Refund_information') }}</a>
                            </li>
                            @can('اجراء استرداد')
                           
                            <li class="nav-item">
                                <a class="nav-link" id="profile-03-tab" data-toggle="tab" href="#profile-03"
                                    role="tab" aria-controls="profile-03"
                                    aria-selected="false">{{ trans('Refund_trans.Refund_prosess') }}</a>
                            </li>
                             @endcan
                            {{-- @can('المالية')
                            <li class="nav-item">
                                <a class="nav-link" id="profile-03-tab" data-toggle="tab" href="#profile-04"
                                    role="tab" aria-controls="profile-03"
                                    aria-selected="false">{{ trans('Statment_trans.Pay_process') }}</a>
                            </li>
                            @endcan --}}
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane fade active show" id="home-02" role="tabpanel"
                                aria-labelledby="home-02-tab">
                                <table class="table table-hover" style="text-align:right">
                                    <tbody>
                                        <tr>
                                            <td scope="row">{{ trans('Refund_trans.doc') }}</td>
                                            <td>
                                                @if ($refund->type == '1')
                                                <span class="label text-info">
                                                    {{ trans('Refund_trans.Certificat') }}
                                                </span>
                                                @elseif ($refund->type == '2')
                                                <span class="label text-info">
                                                    {{ trans('Refund_trans.Statment') }}
                                                </span>
                                                @elseif ($refund->type == '3')
                                                <span class="label text-info">
                                                    {{ trans('Refund_trans.Record') }}
                                                </span>
                                                @else
                                                <span class="label text-info">
                                                    {{ trans('Refund_trans.Register') }} 
                                                </span>
                                                @endif
                                            </td>
                                        </tr>
                                        
                                        <tr>
                                            <td scope="row">{{ trans('Refund_trans.student_name') }}</td>
                                            <td>{{ $refund->user->first_name }} </td>
                                        </tr>

                                        <tr>
                                            <td scope="row">{{trans('Certificat_trans.notification_number')}}</td>
                                            <td>{{ $refund->notification_number }} </td>
                                        </tr>
                                        
                                        <tr>
                                            <td scope="row">{{trans('Certificat_trans.amount')}}</td>
                                            <td>{{ $refund->amount }}</td>
                                        </tr>
                                       
                                        <tr>
                                            <td scope="row">{{ trans('Delivery_trans.request_date') }}</td>
                                            <td>{{ $refund->created_at }}</td>
                                        </tr>
                                        
                                       <tr>
                                        <th>{{ trans('Delivery_trans.stauts') }}</th>
                                        <td>
                                            @if ($refund->stutus == '0')
                                                <span class="label text-info">
                                                     {{ trans('Statment_trans.processing') }}
                                                </span>
                                            @elseif ($refund->stutus == '1')
                                            <span class="label text-success">
                                                {{ trans('Statment_trans.complate') }}
                                            </span>
                                            @else
                                            <span class="label text-danger">
                                                {{ trans('Statment_trans.reject') }}
                                            </span>
                                            @endif
                                        </td>
                                       </tr>
                                       <tr>
                                        @if (isset($refund->note))
                                        <td scope="row">{{ trans('Delivery_trans.note') }}</td>
                                        <td>{{ $refund->note }}</td>
                                        @endif
                                        </tr>
                                       </tr>
                                        <tr>
                                            @if (isset($refund->refund))
                                            <td scope="row">{{trans('Refund_trans.amount2')}}</td>
                                            <td>{{ $refund->refund }}</td>
                                            @endif
                                         </tr>
                                         
                                         <tr>
                                            @if (isset($refund->bank_account))
                                            <td scope="row">{{trans('Refund_trans.bank_account')}}</td>
                                            <td>{{ $refund->bank_account }}</td>
                                            @endif
                                         </tr>

                                         <tr>
                                            @if (isset($refund->account_owner))
                                            <td scope="row">{{trans('Refund_trans.account_owner')}}</td>
                                            <td>{{ $refund->account_owner }}</td>
                                            @endif
                                         </tr>
                                       
                                    </tbody>
                                </table>
                            </div>

                            <div class="tab-pane fade" id="profile-02" role="tabpanel" aria-labelledby="profile-02-tab">
                                <div class="card card-statistics">
                                    <div class="card-body">
                                        
                                    </div>
                                    <br>
                                    <table class="table center-aligned-table mb-0 table table-hover"
                                        style="text-align:center">
                                        <thead>
                                            <tr class="table-secondary">

                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <img src="{{ asset('images/bank/' . $refund->notification) }}">
                                                </td>
                                            </tr>
                                           
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            @can('اجراء استرداد')
                            <div class="tab-pane fade" id="profile-03" role="tabpanel" aria-labelledby="profile-03-tab">
                                <div class="card card-statistics">
                                    <div class="card-body">
                                        {!! Form::open(['url' => 'RefundsProcess', 'autocomplete' => 'off', 'files' => 'ture' ]) !!}   
                                        @csrf
                                       <input type="hidden" name="id" value="{{$refund->id}}">
                                       
                                       <div class="form-group">
                                        <label class="rdiobox"><input name="rdio" value="1"
                                                type="radio"><span> {{ trans('Certificat_trans.accept') }}
                                            </span></label>
                                        </div>
                                        <div class="form-group">
                                            <label class="rdiobox"><input name="rdio" value="2"
                                                    type="radio"><span> {{ trans('Certificat_trans.reject') }}
                                                </span></label>
                                        </div>

                                        <div class="form-group">
                                            <label for="refund">{{trans('Refund_trans.amount2')}} : <span class="text-danger">*</span></label>
                                            <input  class="form-control"  name="refund" type="number" value="{{ old('notification_number') }}">
                                        </div>

                                        <div class="form-group">
                                            <label for="notification_refund">{{trans('Certificat_trans.bank')}} : <span class="text-danger">*</span></label>
                                            <input type="file" name="notification_refund" class="dropify"
                                            accept="image/*" data-height="70" />
                                        </div>
                                      
                                        <div class="col-lg-6">
                                            <label for="exampleFormControlTextarea1"><strong>{{ trans('Delivery_trans.deliveries_emp') }} : </strong></label>
                                            <textarea name="note" class="form-control" wire:model="Address_Father" id="exampleFormControlTextarea1" rows="4"></textarea>
                                        </div>

                                       <br>

                                        <div class="parsley-input col-md-3 mg-t-20 mg-md-t-0">
                                            <button
                                                class="btn btn-primary btn-block">{{ trans('main_trans.save') }}</button>
                                        </div>
                                        </form>

                                        {!! Form::close() !!}
                                    </div>

                                </div>
                            </div>
                            @endcan
                            {{-- @can('المالية')
                            <div class="tab-pane fade" id="profile-04" role="tabpanel" aria-labelledby="profile-03-tab">
                                <div class="card card-statistics">
                                    <div class="card-body">
                                        
                                        {!! Form::open(['url' => 'processpay', 'autocomplete' => 'off' ]) !!}   
                                        @csrf
                                       <input type="hidden" name="id" value="{{$statment->id}}">
                                       
                                        <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                            <label class="rdiobox"><input name="rdio" value="1"
                                                    type="radio"><span> {{ trans('Certificat_trans.accept') }}
                                                </span></label>
                                        </div>
                                        <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                            <label class="rdiobox"><input name="rdio" value="2"
                                                    type="radio"><span> {{ trans('Certificat_trans.reject') }}
                                                </span></label>
                                        </div>
                                        
                                        <div class="col-lg-6">
                                            <label for="exampleFormControlTextarea1">{{ trans('Certificat_trans.note') }}</label>
                                            <textarea name="note" class="form-control" wire:model="Address_Father" id="exampleFormControlTextarea1" rows="4"></textarea>
                                        </div>

                                       <br>

                                        <div class="parsley-input col-md-3 mg-t-20 mg-md-t-0">
                                            <button
                                                class="btn btn-primary btn-block">{{ trans('Main_trans.save') }}</button>
                                        </div>
                                        </form>

                                        {!! Form::close() !!}
                                    </div>

                                </div>
                            </div>
                            @endcan --}}
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <!-- row closed -->
    @endsection
    @section('js')
        @toastr_js
        @toastr_render
        <script src="{{ URL::asset('assets/plugins/fileuploads/js/fileupload.js') }}"></script>
        <script src="{{ URL::asset('assets/plugins/fileuploads/js/file-upload.js') }}"></script>
        <!--Internal Fancy uploader js-->
        <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.ui.widget.js') }}"></script>
        <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fileupload.js') }}"></script>
        <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.iframe-transport.js') }}"></script>
        <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fancy-fileupload.js') }}"></script>
        <script src="{{ URL::asset('assets/plugins/fancyuploder/fancy-uploader.js') }}"></script>

    @endsection
