@extends('layouts.master')
@section('css')
    @toastr_css
    <link href="{{ URL::asset('assets/plugins/fileuploads/css/fileupload.css') }}" rel="stylesheet" type="text/css" />
    <!---Internal Fancy uploader css-->
    <link href="{{ URL::asset('assets/plugins/fancyuploder/fancy_fileupload.css') }}" rel="stylesheet" />
@section('title')
{{ trans('Register_trans.Register_information_edit') }}
@stop
@endsection
@section('page-header')
  <!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> {{ trans('Register_trans.Register_information_edit') }}</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a></li>
                <li class="breadcrumb-item active"> {{ trans('Register_trans.Register_information_edit') }}</li>
            </ol>
        </div>
    </div>
</div>

<!-- breadcrumb -->
@endsection
@section('content')
    <!-- row -->
    <div class="row">
        <div class="col-md-12 mb-30">
            <div class="card card-statistics h-100">
                <div class="card-body">

                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <a href="{{ route('registers.index') }}">
                        <button type="button" class="btn btn-primary l-t-20">
                            {{ trans('main_trans.back') }}
                        </button>
                        <br><br> 
                    </a>
                   
                            {!! Form::model($register, ['method' => 'PATCH','files' => 'ture','route' => ['registers.update', $register->id]]) !!}
                            @csrf
                           
                            <div class="row">
                            
                                @if ($register->lang == '1')
                                <div class="col-lg-3">
                                    <label class="rdiobox">
                                        <input checked name="lang" type="radio" value="1" id="type_div"> <span> {{ trans('Certificat_trans.Arabic') }} </span></label>
                                </div>
            
            
                                <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                    <label class="rdiobox"><input name="lang" value="2" type="radio"><span> {{ trans('Certificat_trans.English') }} </span></label>
                                </div><br><br>

                                @else
                                <div class="col-lg-3">
                                    <label class="rdiobox">
                                        <input  name="lang" type="radio" value="1" id="type_div"> <span> {{ trans('Certificat_trans.Arabic') }} </span></label>
                                </div>
            
            
                                <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                    <label class="rdiobox"><input checked name="lang" value="2" type="radio"><span> {{ trans('Certificat_trans.English') }} </span></label>
                                </div><br><br>

                                @endif
                            </div>

                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>{{ trans('Certificat_trans.First_name') }} : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="first_name" type="text" value="{{ $register->first_name }}">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>{{ trans('Certificat_trans.Second_name') }} : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="second_name" type="text" value="{{ $register->second_name }}">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>{{ trans('Certificat_trans.Third_name') }} : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="midell_name" type="text" value="{{ $register->midell_name }}">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>{{ trans('Certificat_trans.Last_name') }} : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="last_name" type="text" value="{{ $register->last_name }}">
                                    </div>
                                </div>
                            </div>


                            {{-- <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{ trans('Grades_trans.Name') }} : <span class="text-danger">*</span></label>
                                        <select name="grade_id" class="custom-select" <select class="custom-select"
                                            aria-label="Default select example">
                                            <option selected disabled>{{ trans('main_trans.Choose') }}</option>
                                            @foreach($grades as $grade)
                                            <option value='{{ $grade->id}}'{{$grade->id == $register->grade_id ? 'selected' : '' }}> {{ $grade->name}}</option>
                                            @endforeach

                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{ trans('semester_trans.Name_semester') }} : <span class="text-danger">*</span></label>
                                        <select name="semester_id" class="custom-select" <select class="custom-select"
                                            aria-label="Default select example">
                                            <option selected disabled>{{ trans('main_trans.Choose') }}</option>
                                        
                                            @foreach($semesters as $semester)
                                            <option value='{{ $semester->id}}'{{$semester->id == $register->semester_id ? 'selected' : '' }}> {{ $semester->name}}</option>
                                            @endforeach
                                       
                                        </select>
                                    </div>
                                </div>
                            </div> --}}

                            <p class="text-danger">* صيغة المرفقات: jpeg ,jpg , png </p>
                            <div class="row">
                               
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="personal_image">{{trans('Certificat_trans.personal_image')}} : <span class="text-danger">*</span></label>
                                        <input type="file" name="personal_image" class="dropify"
                                        accept="image/*" data-height="70" />
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="ssn">{{trans('Certificat_trans.ssn')}} : <span class="text-danger">*</span></label>
                                        <input type="file" name="ssn" class="dropify"
                                        accept="image/*" data-height="70" />
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="bank">{{trans('Certificat_trans.bank')}} : <span class="text-danger">*</span></label>
                                        <input type="file" name="bank" class="dropify"
                                        accept="image/*" data-height="70" />
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="notification_number">{{trans('Certificat_trans.notification_number')}} : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="notification_number" type="number" value="{{ $register->notification_number }}">
                                    </div>
                                </div>
                               
                            </div><br>

                            <div class="d-flex justify-content-center">
                                <button type="submit" class="btn btn-primary btn-lg">{{trans('Certificat_trans.Edit')}}</button>
                            </div>
                            
                        </form>
                             <br><br>
                </div>
            </div>
        </div>
    </div>
    <!-- row closed -->
@endsection
@section('js')
    @toastr_js
    @toastr_render
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/file-upload.js') }}"></script>
    <!--Internal Fancy uploader js-->
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.ui.widget.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.iframe-transport.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fancy-fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/fancy-uploader.js') }}"></script>
@endsection
