@extends('layouts.master')
@section('css')
    @toastr_css
@section('title')
    {{ trans('Statment_trans.title_page') }}
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> {{ trans('Statment_trans.title_page') }}</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a></li>
                <li class="breadcrumb-item active"> {{ trans('Statment_trans.title_page') }}</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">

    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            <div class="card-body">

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                
                @can('تصدير') 
                <a class="btn btn-warning"
                href="#">
                       تصدير
               </a>

               <a class="btn btn-info"
               href="{{ route('statmentsCount') }}">
                      تقرير
              </a>

             @endcan

            @can('isAdmin') 
           <a href="{{ route('statments.create') }}">
                <button type="button" class="btn btn-primary l-t-20">
                    {{ trans('Statment_trans.submit') }}
                </button>
                <br><br> 
            </a>
           

             @endcan
                <div class="table-responsive">
                    <table id="datatable" class="table table-striped table-bordered p-0">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>{{ trans('Statment_trans.name') }}</th>
                                <th>{{ trans('Depts_trans.Name_Dept') }}</th>
                                <th>{{ trans('Statment_trans.date') }}</th>
                                
                                @can('isAdmin')
                                <th>{{ trans('Statment_trans.by') }}</th>
                                @endcan
                                <th>{{ trans('Statment_trans.Pay_process') }}</th>
                                <th>{{ trans('Statment_trans.Result_process') }}</th>
                                <th>{{ trans('Depts_trans.Processes') }}</th>
                            </tr>
                        </thead>
                        <tboby>
                            @foreach ($statments as $index => $statment)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $statment->first_name }} {{ $statment->second_name }} {{ $statment->midell_name }} {{ $statment->last_name }}</td>
                                    
                                    <td>{{ $statment->dept->name }}</td>
                                    <td>{{ date('d-m-y', strtotime($statment->created_at)) }}</td>
                                    @can('isAdmin')
                                    <td>{{ $statment->user->first_name }} {{ $statment->user->second_name }}</td>
                                    @endcan
                                    <td>
                                        @if ($statment->f_status == '0')
                                            <span class="label text-info">
                                                 {{ trans('Statment_trans.processing') }}
                                            </span>
                                        @elseif ($statment->f_status == '1')
                                        <span class="label text-success">
                                            {{ trans('Statment_trans.complate') }}
                                        </span>
                                        @else
                                        <span class="label text-danger">
                                            {{ trans('Statment_trans.reject') }}
                                        </span>
                                        @endif
                                    </td>
                                    <td>
                                        @if ($statment->r_status == '0')
                                            <span class="label text-info">
                                                 {{ trans('Statment_trans.processing') }}
                                            </span>
                                        @elseif ($statment->r_status == '1')
                                        <span class="label text-success">
                                            {{ trans('Statment_trans.complate') }}
                                        </span>
                                        @else
                                        <span class="label text-danger">
                                            {{ trans('Statment_trans.reject') }}
                                        </span>
                                        @endif
                                    </td>
                                    <td>
                                       
                                       @can('isAdmin') 
                                       <a href="{{ route('statments.edit', encrypt($statment->id)) }}">
                                        <button  type="button" class="btn btn-info btn-sm" data-toggle="modal"
                                        
                                        title="{{ trans('Statment_trans.Edit') }}"><i
                                            class="fa fa-edit"></i></button>
                                       </a>
                                       @endcan
                                       @can('isUser') 
                                       <a href="{{ route('statments.edit', encrypt($statment->id)) }}">
                                        <button  type="button" class="btn btn-info btn-sm" data-toggle="modal"
                                        
                                        title="{{ trans('Statment_trans.Edit') }}"><i
                                            class="fa fa-edit"></i></button>
                                       </a>
                                       @endcan
                                       <a href="{{ route('statments.show', encrypt($statment->id)) }}">
                                        <button  type="button" class="btn btn-success btn-sm" data-toggle="modal"
                                        
                                        title="{{ trans('Statment_trans.show') }}"><i
                                            class="fa fa-eye"></i></button>
                                       </a>
                                       @can('حذف افادة')
                                        <button type="button" class="btn btn-danger btn-sm" data-toggle="modal"
                                            data-target="#delete{{ $statment->id }}"
                                            title="{{ trans('Statment_trans.Delete') }}"><i
                                                class="fa fa-trash"></i></button>
                                       @endcan
                                    </td>
                                </tr>


    <!-- delete_modal_Subject -->
                                <div class="modal fade" id="delete{{ $statment->id }}" tabindex="-1" role="dialog"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 style="font-family: 'Cairo', sans-serif;" class="modal-title"
                                                    id="exampleModalLabel">
                                                    {{ trans('Statment_trans.delete_Statment') }}
                                                </h5> 
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                {!! Form::open(['route' => ['statments.destroy', $statment->id], 'method' => 'DELETE']) !!}
                                                {{ method_field('Delete') }}
                                                @csrf
                                                {{ trans('Statment_trans.Warning_certificat') }}
                                                <input id="id" type="hidden" name="id" class="form-control"
                                                    value="{{ $statment->id }}">
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-dismiss="modal">{{ trans('Statment_trans.Close') }}</button>
                                                    <button type="submit"
                                                        class="btn btn-danger">{{ trans('Statment_trans.Delete') }}</button>
                                                </div>
                                                {!! Form::close() !!}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach


                        </tboby>
                    </table>
                </div>
            </div>
        </div>
    </div>


</div>
<!-- row closed -->
@endsection
@section('js')
@toastr_js
@toastr_render
@endsection
