@extends('layouts.master')
@section('css')
    @toastr_css
@section('title')
    {{ trans('Subjects_trans.title_page') }}
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0">{{ trans('Subjects_trans.title_page') }}</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">الرئيسية</a></li>
                <li class="breadcrumb-item active">{{ trans('Subjects_trans.title_page') }}</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">

    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            <div class="card-body">

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif


                <button type="button" class="button x-small" data-toggle="modal" data-target="#exampleModal">
                    {{ trans('Subjects_trans.add_Subject') }}
                </button>
                <br><br>

                <div class="table-responsive">
                    <table id="datatable" class="table table-striped table-bordered p-0">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>{{ trans('Subjects_trans.Name_Subject') }}</th>
                                <th>{{ trans('Subjects_trans.Name_Dept') }}</th>
                                <th>{{ trans('Subjects_trans.Semester_Name') }}</th>
                                <th>{{ trans('Subjects_trans.Processes') }}</th>
                            </tr>
                        </thead>
                        <tboby>
                            @foreach ($subjects as $index => $subject)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $subject->name }}</td>
                                    <td>{{ $subject->dept->name }}</td>
                                    <td>{{ $subject->semester->name }}</td>
                                    <td>
                                        <button type="button" class="btn btn-info btn-sm" data-toggle="modal"
                                            data-target="#edit{{ $subject->id }}"
                                            title="{{ trans('Subjects_trans.Edit') }}"><i
                                                class="fa fa-edit"></i></button>
                                        <button type="button" class="btn btn-danger btn-sm" data-toggle="modal"
                                            data-target="#delete{{ $subject->id }}"
                                            title="{{ trans('Subjects_trans.Delete') }}"><i
                                                class="fa fa-trash"></i></button>
                                    </td>
                                </tr>


                                <!-- edit_modal_Subject -->
                                <div class="modal fade" id="edit{{ $subject->id }}" tabindex="-1" role="dialog"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 style="font-family: 'Cairo', sans-serif;" class="modal-title"
                                                    id="exampleModalLabel">
                                                    {{ trans('Subjects_trans.edit_Subject') }}
                                                </h5>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <!-- add_form -->
                                                {!! Form::model($subject, ['route' => ['subjects.update', $subject->id], 'method' => 'PUT', 'autocomplete' => 'off']) !!}
                                                @csrf
                                                <div class="row">
                                                    <div class="col">
                                                        <label for="Name"
                                                            class="mr-sm-2">{{ trans('Subjects_trans.Subject_name_ar') }}
                                                            :</label>
                                                        <input id="Name" type="text" name="Name" class="form-control"
                                                            value="{{ $subject->getTranslation('name', 'ar') }}"
                                                            required>
                                                        <input id="id" type="hidden" name="id" class="form-control"
                                                            value="{{ $subject->id }}">
                                                    </div>
                                                    <div class="col">
                                                        <label for="Name_en"
                                                            class="mr-sm-2">{{ trans('Subjects_trans.Subject_name_en') }}
                                                            :</label>
                                                        <input type="text" class="form-control"
                                                            value="{{ $subject->getTranslation('name', 'en') }}"
                                                            name="Name_en" required>
                                                    </div>
                                                </div>
                                                <br><br>

                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-dismiss="modal">{{ trans('Subjects_trans.Close') }}</button>
                                                    <button type="submit"
                                                        class="btn btn-success">{{ trans('Subjects_trans.submit') }}</button>
                                                </div>
                                                {!! Form::close() !!}
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- delete_modal_Subject -->
                                <div class="modal fade" id="delete{{ $subject->id }}" tabindex="-1" role="dialog"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 style="font-family: 'Cairo', sans-serif;" class="modal-title"
                                                    id="exampleModalLabel">
                                                    {{ trans('Subjects_trans.delete_Subject') }}
                                                </h5>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                {!! Form::open(['route' => ['subjects.destroy', $subject->id], 'method' => 'DELETE']) !!}
                                                {{ method_field('Delete') }}
                                                @csrf
                                                {{ trans('Subjects_trans.Warning_Subject') }}
                                                <input id="id" type="hidden" name="id" class="form-control"
                                                    value="{{ $subject->id }}">
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-dismiss="modal">{{ trans('Subjects_trans.Close') }}</button>
                                                    <button type="submit"
                                                        class="btn btn-danger">{{ trans('Subjects_trans.submit') }}</button>
                                                </div>
                                                {!! Form::close() !!}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach


                        </tboby>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- add_modal_Subject -->
    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" style="font-family: 'Cairo', sans-serif;" id="exampleModalLabel">
                        {{ trans('subjects_trans.add_Subject') }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">

                    <form action="{{ route('subjects.store') }}" method="POST" autocomplete="off">
                        {{ csrf_field() }}
                        <div class="row">
                            <div class="col">
                                <input type="text" name="Name" class="form-control"
                                    placeholder="{{ trans('Subjects_trans.Subject_name_ar') }}">
                            </div>

                            <div class="col">
                                <input type="text" name="Name_en" class="form-control"
                                    placeholder="{{ trans('Subjects_trans.Subject_name_en') }}">
                            </div>

                        </div>
                        <br>


                        <div class="col">
                            <label for="inputName"
                                class="control-label">{{ trans('Subjects_trans.Name_Dept') }}</label>
                            <select name="dept_id" class="custom-select" <select class="custom-select"
                                aria-label="Default select example">
                                <option selected>اختيار القسم</option>
                                @foreach ($depts as $dept)
                                    <option value='{{ $dept->id }}'> {{ $dept->name }}</option>
                                @endforeach
                            </select>
                        </div><br>
                       <div class="col">
                            <label for="inputName"
                                class="control-label">{{ trans('Subjects_trans.Semester_Name') }}</label>
                            <select name="semester_id" class="custom-select" <select class="custom-select"
                                aria-label="Default select example">
                                <option selected>اختيار الفصل الدراسي</option>
                                @foreach ($semesters as $semester)
                                        <option value='{{ $semester->id }}'> {{ $semester->name }}</option>
                                    @endforeach
                            </select>
                        </div><br>
                        <div class="col">
                            <label for="inputName"
                                class="control-label">{{ trans('Subjects_trans.Subject_hours') }}</label>
                            <select name="hours" class="custom-select" <select class="custom-select"
                                aria-label="Default select example">
                                <option selected>اختيار عدد الساعات</option>
                                <option value='2'> 2</option>
                                <option value='3'> 3</option>
                            </select>
                        </div><br>


                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary"
                        data-dismiss="modal">{{ trans('Subjects_trans.Close') }}</button>
                    <button type="submit" class="btn btn-danger">{{ trans('Subjects_trans.submit') }}</button>
                </div>
                </form>
            </div>
        </div>
    </div>


</div>
<!-- row closed -->
@endsection
@section('js')
@toastr_js
@toastr_render
@endsection
