@extends('layouts.master')
@section('css')

@section('title')
{{ trans('Certificat_trans.reports') }} / {{ trans('Report_trans.GenralFinancialReport') }}
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0">{{ trans('Certificat_trans.reports') }} / {{ trans('Report_trans.GenralFinancialReport') }}</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a></li>
                <li class="breadcrumb-item active">{{ trans('Report_trans.GenralFinancialReport') }} </li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">
    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            <div class="card-body">
               
                    <div class="row">

                        <div class="col-lg-3 mg-t-20 mg-lg-t-0" id="type"> <br>
                            <strong>{{ trans('Certificat_trans.Certificates') }}</strong><br>
                            <span class="text-info"> {{ trans('Certificat_trans.sumReport') }} : {{$certificatsSum}}</span> <br>
                            <span class="text-success"> {{ trans('Report_trans.complate') }} : 
                                {{ number_format(\App\Models\Certificat::where('f_status', '1')->count('id')) }}
                            </span> <br>
                            <span class="text-danger"> {{ trans('Report_trans.reject') }} : 
                                {{ number_format(\App\Models\Certificat::where('f_status', '2')->count('id')) }}
                            </span><br><br>
                                @can('تصدير') 
                                <a class="btn btn-warning"
                                href="{{ route('certificatexport') }}">
                                {{ trans('Report_trans.Export') }}
                               </a>
                               <a class="btn btn-info"
                                href="{{ route('certificatsCount') }}">
                                {{ trans('Report_trans.Report') }}
                                </a>
                               @endcan
                        </div>
                        <div class="col-lg-3" id="end_at"><br>
                            <strong>{{ trans('Document_trans.documents') }}</strong><br>
                            <span class="text-info"> {{ trans('Document_trans.sumReport') }} : {{$documentSum}} </span><br>
                            <span class="text-success"> {{ trans('Report_trans.complate') }} : 
                                {{ number_format(\App\Models\Document::where('f_status', '1')->count('id')) }}
                            </span> <br>
                            <span class="text-danger"> {{ trans('Report_trans.reject') }} : 
                                {{ number_format(\App\Models\Document::where('f_status', '2')->count('id')) }}
                            </span><br><br>
                            @can('تصدير') 
                            <a class="btn btn-warning"
                            href="{{ route('DocumentsExport') }}">
                            {{ trans('Report_trans.Export') }}
                           </a>
                           <a class="btn btn-info"
                           href="{{ route('documentsCount') }}">
                            {{ trans('Report_trans.Report') }}
                            </a> 
                           @endcan
                        </div>
                        <div class="col-lg-2" id="start_at"><br>
                            <strong>{{ trans('Record_trans.statments') }}</strong><br>
                            <span class="text-info"> {{ trans('Report_trans.all_count') }} : 
                                {{ number_format(\App\Models\Statment::count('id')) }}
                            </span><br>
                            <span class="text-success"> {{ trans('Report_trans.complate') }} : 
                                {{ number_format(\App\Models\Statment::where('f_status', '1')->count('id')) }}
                            </span><br>

                            <span class="text-danger"> {{ trans('Report_trans.reject') }} : 
                                {{ number_format(\App\Models\Statment::where('f_status', '2')->count('id')) }}
                            </span><br><br>
                            @can('تصدير') 
                           <a class="btn btn-info"
                           href="{{ route('statmentsCount') }}">
                            {{ trans('Report_trans.Report') }}
                            </a>
                           @endcan
                        </div>

                        <div class="col-lg-2" id="end_at"><br>
                            <strong>{{ trans('Record_trans.records') }}</strong><br>
                            <span class="text-info"> {{ trans('Report_trans.all_count') }} : 
                            {{ number_format(\App\Models\Record::count('id')) }}
                            </span><br>
                            <span class="text-success"> {{ trans('Report_trans.complate') }} : 
                                {{ number_format(\App\Models\Record::where('f_status', '1')->count('id')) }}
                            </span><br>

                            <span class="text-danger"> {{ trans('Report_trans.reject') }} : 
                                {{ number_format(\App\Models\Record::where('f_status', '2')->count('id')) }}
                            </span><br><br>
                            @can('تصدير') 
                            <a class="btn btn-info"
                            href="{{ route('recordsCount') }}">
                             {{ trans('Report_trans.Report') }}
                             </a>
                            @endcan
                        </div>

                        <div class="col-lg-2" id="end_at"><br>
                            <strong>{{ trans('Register_trans.Register') }}</strong><br>
                            <span class="text-info"> {{ trans('Report_trans.all_count') }} : 
                                {{ number_format(\App\Models\Register::count('id')) }}
                            </span><br>
                            <span class="text-success"> {{ trans('Report_trans.complate') }} : 
                                {{ number_format(\App\Models\Register::where('f_status', '1')->count('id')) }}
                            </span><br>
                            <span class="text-danger"> {{ trans('Report_trans.reject') }} : 
                                {{ number_format(\App\Models\Register::where('f_status', '2')->count('id')) }}
                            </span><br><br>
                           
                            @can('تصدير') 
                            <a class="btn btn-info"
                            href="{{ route('registersCount') }}">
                             {{ trans('Report_trans.Report') }}
                             </a>
                            @endcan
                        </div>
                        
                    </div><br>

                    <div class="row">
                        <div class="col-lg-3 mg-t-20 mg-lg-t-0" id="type"> <br>
                            <strong>{{ trans('Refund_trans.title_page') }}</strong><br>
                            <span class="text-info"> {{ trans('Refund_trans.Refund_total') }} : {{$refund}}</span> <br>
                            <span class="text-success"> {{ trans('Report_trans.complate') }} : 
                                {{ number_format(\App\Models\Refund::where('stutus', '1')->count('id')) }}
                            </span> <br>
                            <span class="text-danger"> {{ trans('Report_trans.reject') }} : 
                                {{ number_format(\App\Models\Refund::where('stutus', '2')->count('id')) }}
                            </span><br><br>
                                @can('تصدير') 
                                <a class="btn btn-warning"
                                href="{{ route('ExportRefunds') }}">
                                {{ trans('Report_trans.Export') }}
                               </a>
                               <a class="btn btn-info"
                                href="{{ route('RefundsReport') }}">
                                {{ trans('Report_trans.Report') }}
                                </a>
                               @endcan
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- row closed -->
@endsection
@section('js')

@endsection
