@extends('layouts.master')
@section('css')
    @toastr_css
@section('title')
{{ trans('Report_trans.title_page') }} - {{ trans('Certificat_trans.Certificates') }}
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> {{ trans('Certificat_trans.reports') }} / {{ trans('Certificat_trans.title_page') }}</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a></li>
                <li class="breadcrumb-item active"> {{ trans('Certificat_trans.reports') }} </li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">

    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            <div class="card-body">

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
               <br>
            </a>
                <div class="table-responsive">
                    <table class="table table-striped table-bordered p-0">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>{{ trans('Certificat_trans.name') }}</th>
                                <th> {{ trans('Certificat_trans.language') }}</th>
                                <th>{{ trans('Certificat_trans.certificat_type') }}</th>
                                <th>{{trans('Certificat_trans.certificat_number')}}</th>
                                <th>{{trans('Certificat_trans.notification_number')}}</th>
                                <th>{{trans('Certificat_trans.amount')}}</th>
                                @can('المالية')
                                <th>{{ trans('Statment_trans.Pay_process') }}</th>
                                @endcan
                                @can('النتيجة')
                                <th>{{ trans('Statment_trans.Result_process') }}</th>
                                @endcan
                            </tr>
                        </thead>
                        <tboby>
                            @foreach ($certificats as $index => $certificat)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    @if (isset($certificat->first_name[0]))
                                    <td>{{ $certificat->first_name[0] }} {{ $certificat->second_name[0] }} {{ $certificat->midell_name[0] }} {{ $certificat->last_name[0] }}</td>
                                    @else
                                    <td>{{ $certificat->first_name[1] }} {{ $certificat->second_name[1] }} {{ $certificat->midell_name[1] }} {{ $certificat->last_name[1] }}</td>
                                    @endif
                                    <td>
                                        @if ($certificat->lang ==["11"])
                                        {{ trans('Certificat_trans.Arabic') }}
                                        @elseif ($certificat->lang == ["21"])
                                        {{ trans('Certificat_trans.English') }}
                                        @else
                                        {{ trans('Certificat_trans.Arabic') }} - {{ trans('Certificat_trans.English') }}
                                        @endif
                                    </td>
                                    <td>
                                        @if ($certificat->certificat_type == ["1"])
                                        {{ trans('Certificat_trans.Details') }}
                                        @elseif ($certificat->certificat_type == ["2"])
                                        {{ trans('Certificat_trans.Regular') }}
                                        @else
                                                {{ trans('Certificat_trans.Regular') }} - {{ trans('Certificat_trans.Details') }}
                                        @endif
                                    </td>
                                    <td>{{ $certificat->certificat_number }}</td>
                                    <td>{{ $certificat->notification_number }}</td>
                                    <td>{{ $certificat->amount }}</td>
                                    @can('المالية')
                                    <td>
                                        @if ($certificat->f_status == '0')
                                            <span class="label text-info">
                                                 {{ trans('Statment_trans.processing') }}
                                            </span>
                                        @elseif ($certificat->f_status == '1')
                                        <span class="label text-success">
                                            {{ trans('Statment_trans.complate') }}
                                        </span>
                                        @else
                                        <span class="label text-danger">
                                            {{ trans('Statment_trans.reject') }}
                                        </span>
                                        @endif
                                    </td>
                                    @endcan
                                    @can('النتيجة')
                                    <td>
                                        @if ($certificat->r_status == '0')
                                            <span class="label text-info">
                                                 {{ trans('Statment_trans.processing') }}
                                            </span>
                                        @elseif ($certificat->r_status == '1')
                                        <span class="label text-success">
                                            {{ trans('Statment_trans.complate') }}
                                        </span>
                                        @else
                                        <span class="label text-danger">
                                            {{ trans('Statment_trans.reject') }}
                                        </span>
                                        @endif
                                    </td>
                                    @endcan
                                </tr>

                            @endforeach


                        </tboby>
                    </table>
                </div>
            </div>
        </div>
    </div>

</div>
<!-- row closed -->
@endsection
@section('js')
@toastr_js
@toastr_render
@endsection
