@extends('layouts.master')
@section('css')
    @toastr_css
    <link href="{{ URL::asset('assets/plugins/fileuploads/css/fileupload.css') }}" rel="stylesheet" type="text/css" />
    <!---Internal Fancy uploader css-->
    <link href="{{ URL::asset('assets/plugins/fancyuploder/fancy_fileupload.css') }}" rel="stylesheet" />
@section('title')
{{ trans('Certificat_trans.title_page') }}
@stop
@endsection
@section('page-header')
    <!-- breadcrumb -->
@section('PageTitle')
{{ trans('Certificat_trans.reports') }} 
@stop
<!-- breadcrumb -->
@endsection
@section('content')
    <!-- row -->
    <div class="row">
        <div class="col-md-12 mb-30">
            <div class="card card-statistics h-100">
                <div class="card-body">

                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                   
                        {{-- <form method="post"  action="{{ route('certificats.store') }}" autocomplete="off" files="ture"> --}}
                         {!! Form::open(['route' => 'reports.index', 'autocomplete' => 'off','method'=>'POST' ]) !!}   
                            @csrf
                            {{ method_field('get') }}
                           
                                <div class="col-lg-3">
                                    <label class="rdiobox">
                                        <input checked name="rdio" type="radio" value="0" id="type_div"> <span> {{ trans('Certificat_trans.Process') }}</span></label>
                                </div>
            
            
                                <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                    <label class="rdiobox"><input name="rdio" value="1" type="radio"><span> {{ trans('Certificat_trans.complate') }} </span></label> 
                                </div>
                                <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                    <label class="rdiobox"><input name="rdio" value="2" type="radio"><span> {{ trans('Certificat_trans.reject') }} </span></label> 
                                </div>
                                
                            <div class="parsley-input col-md-3 mg-t-20 mg-md-t-0">
                                <button class="btn btn-primary btn-block">{{ trans('main_trans.show') }}</button>
                            </div>
                        </form>
                            
                         {!! Form::close() !!}

                </div>
            </div>
        </div>
    </div>
    <!-- row closed -->
@endsection
@section('js')
    @toastr_js
    @toastr_render
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/file-upload.js') }}"></script>
    <!--Internal Fancy uploader js-->
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.ui.widget.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.iframe-transport.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fancy-fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/fancy-uploader.js') }}"></script>
@endsection
