@extends('layouts.master')
@section('css')
    @toastr_css
    <link href="{{ URL::asset('assets/plugins/fileuploads/css/fileupload.css') }}" rel="stylesheet" type="text/css" />
    <!---Internal Fancy uploader css-->
    <link href="{{ URL::asset('assets/plugins/fancyuploder/fancy_fileupload.css') }}" rel="stylesheet" />
@section('title')
{{ trans('Report_trans.title_page') }} - {{ trans('Record_trans.statments') }}
@stop
@endsection
@section('page-header')
    <!-- breadcrumb -->
@section('PageTitle')
{{ trans('Report_trans.title_page') }} 
@stop
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> {{ trans('Report_trans.title_page') }}</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a></li>
                <li class="breadcrumb-item active"> {{ trans('Report_trans.title_page') }}</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')

@if ($errors->any())
<div class="alert alert-danger">
    <ul>
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif
    <!-- row -->
    <div class="row">
        <div class="col-md-12 mb-30">
            <div class="card card-statistics h-100">
                <div class="card-body">
                    <strong>{{ trans('Report_trans.statistic') }} </strong>
                        <table class="table table-hover" style="text-align:right">
                            <tbody>
                                <tr>
                                    <td scope="row">{{ trans('Report_trans.allStatment') }}</td>
                                    <td scope="row"> {{ trans('Report_trans.complateStatment') }}</td>
                                    <td scope="row">{{ trans('Report_trans.PayRejectStatment') }}</td>
                                    <td scope="row">{{ trans('Report_trans.ResultRejectStatment') }}</td>
                                </tr>
                                <tr>
                                    <td><span class="label text-info">{{ $allStatment }} </span></td>
                                    <td><span class="label text-success">{{ $complateStatment }}</span></td>
                                    <td><span class="label text-danger">{{ $PayRejectStatment }}</span></td>
                                    <td><span class="label text-danger">{{ $ResultRejectStatment }}</span></td>
                                </tr>
                            </tbody>
                        </table>
                    <div>
                        <strong>{{ trans('Report_trans.dept_report') }} </strong> 
                    </div><br>

                    <div class="table-responsive">
                        <table class="table table-striped table-bordered p-0">
                            <thead>
                               
                                <tr>
                                    <th>{{ trans('Report_trans.dept_no') }}</th>
                                    <th>  {{ trans('Report_trans.dept_name') }}</th>
                                    <th> {{ trans('Report_trans.Statment_no') }}</th>
                                    
                                </tr>
                            </thead>
                            <tboby>
                                <tbody>
                                    @foreach ($depts as $dept)
                                         <tr>  
                                             <td>{{ $dept->id }}</td>
                                             <td>{{ $dept->name }}</td>
                                             <td>{{ $dept->statments->count() }}</td>
                                         </tr>
                                     @endforeach
                                 </tbody>
                            </tboby>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <!-- row closed -->
@endsection
@section('js')
    @toastr_js
    @toastr_render
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/file-upload.js') }}"></script>
    <!--Internal Fancy uploader js-->
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.ui.widget.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.iframe-transport.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fancy-fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/fancy-uploader.js') }}"></script>
@endsection
