<?php

namespace App\Http\Controllers;

use App\Models\Lab;
use App\Models\Code;
use App\Models\Unit;
use App\Http\Requests\StoreLabRequest;
use App\Http\Requests\UpdateLabRequest;
use Illuminate\Http\Request;

class LabController extends Controller
{
    function __construct()
    { 

    $this->middleware('permission:show lab', ['only' => ['index']]);
    $this->middleware('permission:add lab', ['only' => ['create','store']]);
    $this->middleware('permission:update lab', ['only' => ['edit','update']]);
    $this->middleware('permission:delete lab', ['only' => ['destroy']]);

    }
   
    public function index()
    {
        $labs =  Lab::where('year_id','1')->get();
        $l1abs =  Lab::where('year_id','2')->get();
        $l2abs =  Lab::where('year_id','3')->get();
        $units =  Unit::all();
        //dd($l2abs);
        return view('pages.Labs.index',compact('labs','units','l1abs','l2abs'));
    }

    
    public function create()
    {
        //
    }

  
    public function store(StoreLabRequest $request)
    {
        //
    }

    
    public function show($id)
    {
        $lab_id = decrypt($id);
        $lab = Lab::where('id',$lab_id)->first();
        $codes = Code::where('lab_id',$lab_id)->get();
        

        return view('pages.Labs.show',compact('lab','codes'));

    }

   
    public function edit(Lab $lab)
    {
        //
    }

    
    public function update(UpdateLabRequest $request, Lab $lab)
    {
        //dd($request->all());
        try {

            $validated = $request->validated();
            $lab = Lab::findOrFail($request->id);
           
            $lab->desc = $request->desc;
            $lab->qty = $request->qty;
            $lab->budget = $request->budget;
            $lab->unit_id = $request->unit_id;
            $lab->save();

            toastr()->success(trans('messages.Update'));
            return redirect()->route('labs.index');
        }
        catch
        (\Exception $e) {
            return redirect()->back()->withErrors(['error' => $e->getMessage()]);
        }

    }

   
    public function destroy(Request $request)
    {
        try {
            
             $lab = Lab::where('id',$request->id)->first();
             $lab->delete();
             toastr()->error(trans('messages.Delete'));
            return redirect()->route('labs.index');
        }

        catch (\Exception $e){
        return redirect()->back()->withErrors(['error' => $e->getMessage()]);
        }


    }



}
