<?php

namespace App\Http\Controllers;
use App\Models\Payment;
use App\Models\Lab;
use App\Models\Code;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;


class ReportsController extends Controller
{

    
    public function index(Request $request)
    {
        
        $codes = Payment::select(
            'code_id',
            DB::raw('YEAR(created_at) as year'),
            DB::raw('MONTH(created_at) as month'),
            DB::raw('SUM(amount) as total_amount')
        )
            ->groupBy('code_id', 'year', 'month')
            ->orderBy('month', 'asc')
            ->get();
           

        return view('pages.Reports.Monthly',compact('codes'));
    
    }
 
    
    public function getcodesid(Request $request)
    {
       
        $codes =  Code::all();
        $labs = Lab::where('year_id','2')->pluck('desc','id');
        
        return view('pages.Reports.getcodesid',compact('codes','labs'));
    }
    public function getcodesReport(Request $request)
    {
       
        $codeId = $request->input('code');
        $code = Code::where('id',$codeId)->first();
        $codes = Payment::where('code_id', $codeId)->get();
       // dd($codes);
        return view('pages.Reports.getcodesReport',compact('codes','code'));
    }

    
   
    public function store(Request $request)
    {
        //
    }

   
    public function show($id)
    {
        $centerData = DB::table('log_activities')->get();
    }


    public function certificatsPrint()
    {
        $certificats = Certificat::where('f_status','1')
        ->where('r_status','1')
        ->where('print','0')
        ->get();
        return view('pages.reports.certificatsPrint',compact('certificats'));
    }

    public function CertificatesComplate()
    {
        $certificats = Certificat::where('f_status','1')
        ->where('r_status','1')
        ->where('print','1')
        ->get();
        return view('pages.reports.CertificatesComplate',compact('certificats'));
    }
    
    public function documentsCount()
    {
        $documents = Document::all();
        $documentSum = Document::where('f_status','1')->sum('amount');
        return view('pages.reports.documentsCount',compact('documents','documentSum'));
    }
    
    public function GenralFinancialReport()
    {
       
        $AllRecordAmountSum = Record::sum('amount');
        $AceptRecordAmountSum = Record::where('f_status','1')->sum('amount');
        $RejectRecordAmountSum = Record::where('f_status','2')->sum('amount');

        $AllStatmentAmountSum = Statment::sum('amount');
        $AceptStatmentAmountSum = Statment::where('f_status','1')->sum('amount');
        $RejectStatmentAmountSum = Statment::where('f_status','2')->sum('amount');


        $AlldocumentAmountSum = Document::sum('amount');
        $AceptdocumentAmountSum = Document::where('f_status','1')->sum('amount');
        $RejectdocumentAmountSum = Document::where('f_status','2')->sum('amount');

        $AllCertificatsAmountSum = Certificat::sum('amount'); 
        $AceptCertificatsAmountSum = Certificat::where('f_status','1')->sum('amount'); 
        $RejectCertificatsAmountSum = Certificat::where('f_status','2')->sum('amount'); 
        $refund = Refund::where('stutus','1')->sum('amount');
       // dd($allSum.'-'.$certificatsSuma.'-'.$certificatsSumr);
        return view('pages.reports.GenralFinancialReport',
        compact(
        'AllRecordAmountSum',
        'AceptRecordAmountSum',
        'RejectRecordAmountSum',

        'AllStatmentAmountSum',
        'AceptStatmentAmountSum',
        'RejectStatmentAmountSum',

        'AlldocumentAmountSum',
        'AceptdocumentAmountSum',
        'RejectdocumentAmountSum',
        'RejectCertificatsAmountSum',
        'AceptCertificatsAmountSum',
        'refund',
        'AllCertificatsAmountSum',
        'RejectCertificatsAmountSum'
    ));
    }
     public function CertificatesRadyToDelver()
    {
        
        $certificats = Certificat::where('f_status','1')
        ->where('r_status','1')
        ->where('print','1')
        ->where('delivery_status','0')
        ->get();
        
        return view('pages.reports.CertificatesRadyToDelver',compact('certificats'));
    }
    public function update(Request $request, $id)
    {
        //
    }

   
    public function destroy($id)
    {
        //
    }
}
