<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UserStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'first_name' => 'required',
            'email' => 'required|email|unique:users,email',
            'password' => 'required',
            //'phone' => 'required|min:10|regex:/^([0-9\s\-\+\(\)]*)$/',
            //'gender_id' => 'required',
            'roles_name' => 'required',
          
        ];
    }

    public function messages()
    {
        return [

            'first_name.required' =>'يرجي ادخال الاسم ',
            'email.required' =>'يرجي ادخال البريد الالكتروني ',
            'password.required' =>'يرجي ادخال  كلمة المرور ',
            //'phone.required' =>'يرجى ادخال رقم الهاتف',
            'dept_id.required' =>'يرجي ادخال القسم ',
            //'gender_id.required' =>'يرجى ادخال النوع ',
            'roles_name.required' =>'يرجى اختيار الصلاحية',
            
        ];
    }


}
