<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\Course;
use App\Models\Payment;
use App\Models\Lab;
use App\Models\Year;
use Carbon\Carbon;


class Code extends Model
{
    
    use HasFactory,SoftDeletes;
    
    
    protected $guarded = []; 
    public function course()
    {
        return $this->belongsTo(Course::class);
    }
    public function lab()
    {
        return $this->belongsTo(Lab::class);
    }
    public function year()
    {
        return $this->belongsTo(Year::class);
    }
    public function payments()
    {
        return $this->hasMany(Payment::class); 
    }
    public function getCreatedAtAttribute($date)
    {
        return Carbon::createFromFormat('Y-m-d H:i:s', $date)->format('Y-m-d');
    }

    public function getUpdatedAtAttribute($date)
    {
        return Carbon::createFromFormat('Y-m-d H:i:s', $date)->format('Y-m-d');
    }


}
