<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\Category;
use App\Models\Code;
use App\Models\Payment;

class Course extends Model
{
    use HasFactory,SoftDeletes;


    protected $guarded = []; 
    public function category()
    {
        return $this->belongsTo(Category::class);
    }
    public function codes()
    {
        return $this->hasMany(Code::class); 
    }
    public function payments()
    {
        return $this->hasMany(Payment::class); 
    }

}
