<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\Unit;
use App\Models\Category;
use App\Models\Code;
use App\Models\Year;
use App\Models\Payment;

class Lab extends Model
{
    use HasFactory,SoftDeletes;
    protected $guarded = []; 
    public function unit()
    {
        return $this->belongsTo(Unit::class);
    }
    public function Year()
    {
        return $this->belongsTo(Year::class);
    }
    public function codes()
    {
        return $this->hasMany(Code::class); 
    }
    public function payments()
    {
        return $this->hasMany(Payment::class); 
    }
   
}
