<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\Course;
use App\Models\Code;
use App\Models\User;
use App\Models\lab;
use Carbon\Carbon;




class Payment extends Model
{
    use HasFactory,SoftDeletes;
    protected $guarded = []; 
   
    public function code()
    {
        return $this->belongsTo(Code::class);
    }
    public function user()
    {
        return $this->belongsTo(User::class);
    }
    
    public function course()
    {
        return $this->belongsTo(Course::class); 
    }
    public function lab()
    {
        return $this->belongsTo(Lab::class); 
    }
    public function getCreatedAtAttribute($date)
    {
        return Carbon::createFromFormat('Y-m-d H:i:s', $date)->format('Y-m-d');
    }

    public function getUpdatedAtAttribute($date)
    {
        return Carbon::createFromFormat('Y-m-d H:i:s', $date)->format('Y-m-d');
    }

}
