<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('first_name');
            $table->string('second_name')->nullable();
            $table->string('midell_name')->nullable();
            $table->string('last_name')->nullable();
            $table->text('roles_name');
            $table->string('user_type')->default('user');
            $table->string('email')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->string('phone')->nullable();
            $table->string('address')->nullable();
            $table->string('certificats')->default('0');
             //$table->string('f_phone')->nullable();
            // $table->unsignedBigInteger('grade_id')->nullable();
            // $table->unsignedBigInteger('semester_id')->nullable();
            // $table->unsignedBigInteger('blood_id')->nullable();
            // $table->unsignedBigInteger('religion_id')->nullable();
            // $table->string('ssn')->nullable();
            // $table->date('birth_date')->nullable();
            
            $table->rememberToken();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
};
