<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('labs', function (Blueprint $table) {
            $table->id();
            $table->text('desc');
            $table->bigInteger('qty');
            $table->double('budget');
            $table->double('execute');
            $table->double('balance');
            $table->double('cost');
            $table->double('total');
            $table->unsignedBigInteger('unit_id')->default('1');
            $table->unsignedBigInteger('year_id');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('labs');
    }
};
