<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Category;
use Illuminate\Support\Facades\DB;


class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('categories')->delete();
        $categories = [
           
            ['name' => 'Educational Offerings'],
            ['name' => 'Material Library and Idea Lab Collection'],
            ['name' => 'COMMISSIONS'],
            ['name' => 'MAKERSPACE'],
            ['name' => 'Outreach Programs'],
            ['name' => 'Machines'],
            ['name' => 'Visas and Travel Expenses'],
            ['name' => 'Reimbursable Costs'],
            ['name' => 'Graphic, Copywriting, Translation and Printing Services'],
            
           
            ];
    
            foreach ($categories as $key => $category) {
    
                Category::create($category);
    
            }
    }
}
