<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Course;
use Illuminate\Support\Facades\DB;

class CourseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('courses')->delete();
        $courses = [
           
            ['name' => 'Workshops','category_id' => '1'],
            ['name' => 'Tanween Challenges','category_id' => '1'],
            ['name' => 'Educational Offerings Facilitation','category_id' => '1'],
            
            ['name' => 'Material Library and Idea Lab Collection','category_id' => '2'],

            ['name' => 'COMMISSIONS','category_id' => '3'],
            ['name' => 'MAKERSPACE','category_id' => '4'],

            ['name' => 'Outreach Programs','category_id' => '5'],
            ['name' => 'Machines','category_id' => '6'],
            ['name' => 'Visas and Travel Expenses','category_id' => '7'],

            ['name' => 'Materials','category_id' => '8'],
            ['name' => 'Travel and Accommodations','category_id' => '8'],

            ['name' => 'Contractor responsibilities','category_id' => '9'],
            ['name' => 'Copywriting & Translation','category_id' => '9'],
            ['name' => 'Graphic Design','category_id' => '9'],
            ['name' => 'Printing','category_id' => '9'],
           
            ];
    
            foreach ($courses as $key => $course) {
    
                Course::create($course);
    
            }
    }
}
