@extends('layouts.master')
@section('css')
    @toastr_css
@section('title')
    {{ trans('Users_trans.personal_information') }}
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
@section('PageTitle')
    {{ trans('Users_trans.personal_information') }}
@stop
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">
    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <h4>
                                <li>{{ $error }}</li>
                            </h4>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="card-body">
                <div class="card-body">
                    <a href="{{ route('codes.index') }}">
                        <button type="button" class="btn btn-primary l-t-20">
                            {{ trans('main_trans.back') }}
                        </button>
                        <br><br>
                    </a>
                    <div class="tab nav-border">
                        <ul class="nav nav-tabs" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active show" id="home-02-tab" data-toggle="tab" href="#home-02"
                                    role="tab" aria-controls="home-02"
                                    aria-selected="true">{{ trans('Users_trans.personal_information') }}</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="profile-02-tab" data-toggle="tab" href="#profile-02"
                                    role="tab" aria-controls="profile-02"
                                    aria-selected="false">{{ trans('Users_trans.Attachments') }}</a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" id="profile-03-tab" data-toggle="tab" href="#profile-03"
                                    role="tab" aria-controls="profile-03"
                                    aria-selected="false">{{ trans('Statment_trans.Result_process') }}</a>
                            </li>

                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane fade active show" id="home-02" role="tabpanel"
                                aria-labelledby="home-02-tab">
                                <table class="table table-hover" style="text-align:right">
                                    <tbody>

                                        <tr>
                                            <th scope="row">{{ trans('Certificat_trans.bank_note') }}</th>
                                            <td> {{ $code->name }} </td>
                                        </tr>

                                        <tr>
                                            <th scope="row">{{ trans('Certificat_trans.comments') }}</th>
                                            <td>{{ $code->execut }} </td>
                                        </tr>

                                        <tr>
                                            <td scope="row">{{ trans('Depts_trans.Name_Dept') }}</td>
                                            <td>{{ $code->created_at }}</td>
                                        </tr>

                                        <tr>


                                    </tbody>
                                </table>
                            </div>

                            <div class="tab-pane fade" id="profile-02" role="tabpanel" aria-labelledby="profile-02-tab">
                                <div class="card card-statistics">
                                    <div class="card-body">
                                        <table class="table center-aligned-table mb-0 table table-hover"
                                            style="text-align:center">
                                            <thead>
                                                <tr class="table-secondary">

                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>
                                                        {{ trans('Certificat_trans.personal_image') }}
                                                        <img height="400" width="400" src="#">
                                                    </td>
                                                    <td>
                                                        {{ trans('Certificat_trans.bank') }}
                                                        <img height="400" width="400" src="#">
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        {{ trans('Certificat_trans.ssn') }}
                                                        <img height="400" width="400" src="#">
                                                    </td>
                                                    @if (isset($certificat->school_certificat))
                                                        <td>
                                                            <img height="400" width="400" src="#">
                                                        </td>
                                                    @endif
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>

                                </div>
                            </div>
                          
                                <div class="tab-pane fade" id="profile-03" role="tabpanel" aria-labelledby="profile-03-tab">
                                    <div class="card card-statistics">
                                        <div class="card-body">
                                            {!! Form::open(['url' => '#', 'autocomplete' => 'off']) !!}
                                            @csrf
                                            <input type="hidden" name="id" value="{{ $code->id }}">

                                            <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                                <label class="rdiobox"><input name="rdio" value="1"
                                                        type="radio"><span> {{ trans('Certificat_trans.accept') }}
                                                    </span></label>
                                            </div>
                                            <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                                <label class="rdiobox"><input name="rdio" value="2"
                                                        type="radio"><span> {{ trans('Certificat_trans.reject') }}
                                                    </span></label>
                                            </div>

                                            <div class="col-lg-6">
                                                <label
                                                    for="exampleFormControlTextarea1">{{ trans('Certificat_trans.note') }}</label>
                                                <textarea name="note" class="form-control" wire:model="Address_Father" id="exampleFormControlTextarea1"
                                                    rows="4"></textarea>
                                            </div>

                                            <br>

                                            <div class="parsley-input col-md-3 mg-t-20 mg-md-t-0">
                                                <button
                                                    class="btn btn-primary btn-block">{{ trans('main_trans.save') }}</button>
                                            </div>
                                            </form>

                                            {!! Form::close() !!}
                                        </div>


                                    </div>
                                </div>
                          
                                <div class="tab-pane fade" id="profile-04" role="tabpanel"
                                    aria-labelledby="profile-03-tab">
                                    <div class="card card-statistics">
                                        <div class="card-body">
                                            {!! Form::open(['url' => '#', 'autocomplete' => 'off']) !!}
                                            @csrf
                                            <input type="hidden" name="id" value="{{ $code->id }}">

                                            <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                                <label class="rdiobox"><input name="rdio" value="1"
                                                        type="radio"><span> {{ trans('Certificat_trans.accept') }}
                                                    </span></label>
                                            </div>
                                            <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                                <label class="rdiobox"><input name="rdio" value="2"
                                                        type="radio"><span> {{ trans('Certificat_trans.reject') }}
                                                    </span></label>
                                            </div>

                                            <div class="col-lg-6">
                                                <label
                                                    for="exampleFormControlTextarea1">{{ trans('Certificat_trans.bank_note') }}</label>
                                                <textarea name="note" class="form-control" wire:model="Address_Father" id="exampleFormControlTextarea1"
                                                    rows="4"></textarea>
                                            </div>

                                            <br>

                                            <div class="parsley-input col-md-3 mg-t-20 mg-md-t-0">
                                                <button
                                                    class="btn btn-primary btn-block">{{ trans('main_trans.save') }}</button>
                                            </div>
                                            </form>

                                            {!! Form::close() !!}
                                        </div>


                                    </div>
                                </div>
                          

                        </div>
                    </div>
                </div>

            </div>
        </div>

        <!-- row closed -->
    @endsection
    @section('js')
        @toastr_js
        @toastr_render
    @endsection
